/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.MuleException;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.file.FileConnector;
import org.mule.providers.file.i18n.FileMessages;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.OutputHandler;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class FileMessageDispatcher
extends AbstractMessageDispatcher {
    private final FileConnector connector;

    public FileMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (FileConnector)endpoint.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(UMOEvent event) throws Exception {
        Object data = event.getTransformedMessage();
        MuleMessage message = new MuleMessage(data, (UMOMessageAdapter)event.getMessage());
        FileOutputStream fos = (FileOutputStream)this.connector.getOutputStream(event.getEndpoint(), (UMOMessage)message);
        try {
            if (event.getMessage().getStringProperty("filename", null) == null) {
                event.getMessage().setStringProperty("filename", message.getStringProperty("filename", ""));
            }
            if (data instanceof byte[]) {
                fos.write((byte[])data);
            } else if (data instanceof String) {
                fos.write(data.toString().getBytes(event.getEncoding()));
            } else if (data instanceof OutputHandler) {
                ((OutputHandler)data).write(event, (OutputStream)fos);
            } else {
                InputStream is = (InputStream)event.getTransformedMessage(InputStream.class);
                IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
                is.close();
            }
        }
        finally {
            this.logger.debug((Object)"Closing file");
            fos.close();
        }
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected static File getNextFile(String dir, FilenameFilter filter) throws UMOException {
        File file = FileUtils.newFile((String)dir);
        File result = null;
        try {
            if (file.exists()) {
                File[] files;
                if (file.isFile()) {
                    result = file;
                } else if (file.isDirectory() && (files = filter != null ? file.listFiles(filter) : file.listFiles()).length > 0) {
                    result = files[0];
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleException(FileMessages.errorWhileListingFiles(), (Throwable)e);
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

