/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.net.URLDecoder;
import org.mule.MuleException;
import org.mule.RegistryContext;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageRequester;
import org.mule.providers.file.FileConnector;
import org.mule.providers.file.FileMessageDispatcher;
import org.mule.providers.file.filters.FilenameWildcardFilter;
import org.mule.providers.file.i18n.FileMessages;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.FileUtils;

public class FileMessageRequester
extends AbstractMessageRequester {
    private final FileConnector connector;

    public FileMessageRequester(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (FileConnector)endpoint.getConnector();
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected UMOMessage doRequest(long timeout) throws Exception {
        File file = FileUtils.newFile((String)this.endpoint.getEndpointURI().getAddress());
        File result = null;
        FilenameWildcardFilter filenameFilter = null;
        String filter = (String)this.endpoint.getProperty((Object)"filter");
        if (filter != null) {
            filter = URLDecoder.decode(filter, RegistryContext.getConfiguration().getDefaultEncoding());
            filenameFilter = new FilenameWildcardFilter(filter);
        }
        if (file.exists()) {
            if (file.isFile()) {
                result = file;
            } else if (file.isDirectory()) {
                result = FileMessageDispatcher.getNextFile(this.endpoint.getEndpointURI().getAddress(), filenameFilter);
            }
            if (result != null) {
                MuleMessage message;
                boolean checkFileAge = this.connector.getCheckFileAge();
                if (checkFileAge) {
                    long fileAge = this.connector.getFileAge();
                    long lastMod = result.lastModified();
                    long now = System.currentTimeMillis();
                    long thisFileAge = now - lastMod;
                    if (thisFileAge < fileAge) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + result.getCanonicalPath()));
                        }
                        return null;
                    }
                }
                File destinationFile = null;
                if (this.connector.getMoveToDirectory() != null) {
                    destinationFile = FileUtils.newFile((String)this.connector.getMoveToDirectory(), (String)result.getName());
                    if (!result.renameTo(destinationFile)) {
                        this.logger.error((Object)("Failed to move file: " + result.getAbsolutePath() + " to " + destinationFile.getAbsolutePath()));
                        message = new MuleMessage((Object)this.connector.getMessageAdapter(result));
                    } else {
                        message = new MuleMessage((Object)this.connector.getMessageAdapter(destinationFile));
                    }
                } else {
                    message = new MuleMessage((Object)this.connector.getMessageAdapter(result));
                }
                if (this.connector.isAutoDelete() && destinationFile == null && !result.delete()) {
                    throw new MuleException(FileMessages.failedToDeleteFile(result.getAbsolutePath()));
                }
                return message;
            }
        }
        return null;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

