/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import org.mule.RegistryContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transport.Connector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.util.FileUtils;

public class AutoDeleteOnFileDispatcherReceiverTestCase
extends AbstractMuleTestCase {
    private File validMessage;
    private String tempDirName = "input";
    File tempDir;
    Connector connector;

    public void testAutoDeleteFalseOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(false);
        MuleEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((MuleEvent)event);
        MuleMessage message = RequestContext.getEventContext().receiveEvent(this.getTestEndpointURI() + "/" + this.tempDirName + "?connector=FileConnector", 50000L);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)message.getPayloadAsString());
        File[] files = this.tempDir.listFiles();
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < files.length; ++i) {
            AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((boolean)files[i].getName().equals(message.getProperty("originalFilename")));
            files[i].delete();
        }
    }

    public void testAutoDeleteTrueOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(true);
        MuleEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((MuleEvent)event);
        MuleMessage message = RequestContext.getEventContext().receiveEvent(this.getTestEndpointURI() + "/" + this.tempDirName, 50000L);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)message.getPayload());
        File[] files = this.tempDir.listFiles();
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((files.length == 0 ? 1 : 0) != 0);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tempDir = FileUtils.newFile((String)RegistryContext.getConfiguration().getWorkingDirectory(), (String)this.tempDirName);
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
        this.validMessage = File.createTempFile("hello", ".txt", this.tempDir);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)this.validMessage);
        this.connector = this.getConnector();
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteTree((File)FileUtils.newFile((String)AutoDeleteOnFileDispatcherReceiverTestCase.getTestConnector().getProtocol()));
        super.doTearDown();
    }

    public Connector getConnector() throws Exception {
        FileConnector connector = new FileConnector();
        connector.setName("FileConnector");
        connector.setMuleContext(muleContext);
        muleContext.getRegistry().registerConnector((Connector)connector);
        return connector;
    }

    public String getTestEndpointURI() {
        return "file://" + muleContext.getRegistry().getConfiguration().getWorkingDirectory();
    }
}

