/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import junit.framework.Assert;
import org.mule.api.MuleEventContext;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.FileUtils;

public class FileComparatorTestCase
extends FunctionalTestCase {
    public static final String PATH = "./.mule/in/";
    public static final String FILE_CONNECTOR_NAME = "fileConnector";
    public static final int TIMEOUT = 50000;
    public static final String[] FILE_NAMES = new String[]{"first", "second"};
    public static final String MODEL_NAME = "ESTest";
    public static final String COMPONENT_NAME = "FolderTO";

    public void testComparator() throws Exception {
        final CountDownLatch countDown = new CountDownLatch(2);
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                int index = (int)countDown.getCount() - 1;
                Assert.assertEquals((Object)context.getMessage().getProperty("originalFilename"), (Object)FILE_NAMES[index]);
                countDown.countDown();
            }
        };
        ((FunctionalTestComponent)muleContext.getRegistry().lookupService(COMPONENT_NAME).getServiceFactory().getOrCreate()).setEventCallback(callback);
        muleContext.getRegistry().lookupConnector(FILE_CONNECTOR_NAME).stop();
        File f1 = FileUtils.newFile((String)(PATH + FILE_NAMES[0]));
        FileComparatorTestCase.assertTrue((boolean)f1.createNewFile());
        Thread.sleep(1000L);
        File f2 = FileUtils.newFile((String)(PATH + FILE_NAMES[1]));
        FileComparatorTestCase.assertTrue((boolean)f2.createNewFile());
        Thread.sleep(1000L);
        muleContext.getRegistry().lookupConnector(FILE_CONNECTOR_NAME).start();
        FileComparatorTestCase.assertTrue((boolean)countDown.await(50000L, TimeUnit.MILLISECONDS));
    }

    protected String getConfigResources() {
        return "file-functional-config.xml";
    }
}

