/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.util.FileUtils;

public class FileConnectorTestCase
extends AbstractConnectorTestCase {
    static final long POLLING_FREQUENCY = 1234L;
    static final long POLLING_FREQUENCY_OVERRIDE = 4321L;
    private File validMessage;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        File tempDir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)"tmp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        this.validMessage = File.createTempFile("simple", ".mule", tempDir);
        FileConnectorTestCase.assertNotNull((Object)this.validMessage);
        FileUtils.writeStringToFile((File)this.validMessage, (String)"validMessage");
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteTree((File)FileUtils.newFile((String)FileConnectorTestCase.getTestConnector().getProtocol()));
        super.doTearDown();
    }

    public Connector createConnector() throws Exception {
        FileConnector connector = new FileConnector();
        connector.setName("testFile");
        return connector;
    }

    public String getTestEndpointURI() {
        return "file://" + muleContext.getConfiguration().getWorkingDirectory();
    }

    public Object getValidMessage() throws Exception {
        return this.validMessage;
    }

    public void testOnlySingleDispatcherPerEndpoint() {
        FileConnector connector = (FileConnector)this.getConnector();
        FileConnectorTestCase.assertEquals((int)1, (int)connector.getMaxDispatchersActive());
        try {
            connector.setMaxDispatchersActive(2);
            FileConnectorTestCase.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FileConnectorTestCase.assertEquals((int)1, (int)connector.getMaxDispatchersActive());
    }
}

