/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.model.streaming.DelegatingInputStream;
import org.mule.module.client.MuleClient;
import org.mule.transport.DefaultMessageAdapter;
import org.mule.transport.file.AbstractFileMoveDeleteTestCase;
import org.mule.transport.file.FileContentsMessageAdapter;
import org.mule.util.IOUtils;

public class FileRequestorMoveDeleteTestCase
extends AbstractFileMoveDeleteTestCase {
    public void testMoveAndDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, true);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, true, true);
    }

    public void testMoveOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, false);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, true, false);
    }

    public void testDeleteOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, true);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, false, true);
    }

    public void testNoMoveNoDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, false);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, false, false);
    }

    public void testMoveAndDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, true);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, true, true);
    }

    public void testMoveOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, true, false);
    }

    public void testDeleteOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, true);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, false, true);
    }

    public void testNoMoveNoDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, false);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, false, false);
    }

    protected void assertRequested(MuleMessage message, File inFile, boolean streaming) throws IOException, MessagingException, InterruptedException {
        Thread.sleep(2000L);
        FileRequestorMoveDeleteTestCase.assertNotNull((Object)message);
        FileRequestorMoveDeleteTestCase.assertNotNull((Object)message.getAdapter());
        FileRequestorMoveDeleteTestCase.assertEquals((Object)inFile.getName(), (Object)message.getAdapter().getProperty("originalFilename"));
        if (streaming) {
            FileRequestorMoveDeleteTestCase.assertEquals(DefaultMessageAdapter.class, message.getAdapter().getClass());
        } else {
            FileRequestorMoveDeleteTestCase.assertEquals(FileContentsMessageAdapter.class, message.getAdapter().getClass());
        }
        FileRequestorMoveDeleteTestCase.assertNotNull((Object)message.getPayload());
        if (streaming) {
            FileRequestorMoveDeleteTestCase.assertTrue((boolean)(message.getPayload() instanceof DelegatingInputStream));
            InputStream fis = (InputStream)message.getPayload();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)fis, (OutputStream)byteOut);
            this.assertFilesUntouched(inFile);
            fis.close();
            String result = new String(byteOut.toByteArray());
            FileRequestorMoveDeleteTestCase.assertEquals((String)"Test file contents", (String)result);
        } else {
            FileRequestorMoveDeleteTestCase.assertTrue((boolean)(message.getPayload() instanceof byte[]));
            FileRequestorMoveDeleteTestCase.assertEquals((String)"Test file contents", (String)new String((byte[])message.getPayload()));
        }
    }

    protected MuleMessage request(File file) throws MuleException, MalformedURLException {
        MuleClient muleClient = new MuleClient();
        return muleClient.request(this.fileToUrl(file) + "?connector=moveDeleteConnector", 2000L);
    }
}

