/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mule.api.MessagingException;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.ObjectUtils;

public class FileMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 4127485947547548996L;
    protected File file = null;
    protected InputStream payload;

    public FileMessageAdapter(Object message) throws MessagingException {
        if (message instanceof File) {
            this.setFileMessage((File)message);
        } else if (message instanceof ReceiverFileInputStream) {
            this.setStreamMessage((ReceiverFileInputStream)message);
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    protected FileMessageAdapter(FileMessageAdapter template) {
        super((MessageAdapter)template);
        this.file = template.file;
        this.payload = template.payload;
    }

    public Object getPayload() {
        return this.payload;
    }

    protected void setFileMessage(File message) throws MessagingException {
        try {
            this.file = message;
            this.payload = new FileInputStream(message);
        }
        catch (IOException ex) {
            throw new MessagingException(FileMessages.fileDoesNotExist(ObjectUtils.toString((Object)message, (String)"null")), (Object)ex);
        }
        this.setProperty("originalFilename", this.file.getName());
        this.setProperty("directory", this.file.getParent());
    }

    protected void setStreamMessage(ReceiverFileInputStream message) throws MessagingException {
        this.file = message.getCurrentFile();
        this.payload = message;
        this.setProperty("originalFilename", this.file.getName());
        this.setProperty("directory", this.file.getParent());
    }

    public String getUniqueId() {
        return this.file.getAbsolutePath();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new FileMessageAdapter(this);
    }
}

