/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapterTestCase;
import org.mule.transport.file.FileMessageAdapter;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.util.FileUtils;

public class FileMessageAdapterTestCase
extends AbstractMessageAdapterTestCase {
    private File message;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        File dir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)"tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.message = File.createTempFile("simple", ".mule", dir);
    }

    public Object getValidMessage() {
        return this.message;
    }

    public MessageAdapter createAdapter(Object payload) throws MessagingException {
        return new FileMessageAdapter(payload);
    }

    public void testMessageRetrieval2() throws Exception {
        ReceiverFileInputStream message = new ReceiverFileInputStream((File)this.getValidMessage(), false, null);
        MessageAdapter adapter = this.createAdapter(message);
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)adapter);
        this.doTestMessageEqualsPayload(message, adapter.getPayload());
        byte[] bytes = muleMessage.getPayloadAsBytes();
        FileMessageAdapterTestCase.assertNotNull((Object)bytes);
        String stringMessage = muleMessage.getPayloadAsString();
        FileMessageAdapterTestCase.assertNotNull((Object)stringMessage);
        FileMessageAdapterTestCase.assertNotNull((Object)adapter.getPayload());
    }

    protected void doTestMessageEqualsPayload(Object message, Object payload) throws Exception {
        byte[] messageBytes = null;
        byte[] payloadBytes = null;
        if (message instanceof File) {
            File file = (File)message;
            FileInputStream payloadFis = (FileInputStream)payload;
            messageBytes = new byte[(int)file.length()];
            payloadBytes = new byte[payloadFis.available()];
            new FileInputStream((File)message).read(messageBytes);
            ((FileInputStream)payload).read(payloadBytes);
        } else if (message instanceof FileInputStream) {
            FileInputStream fis = (FileInputStream)message;
            FileInputStream payloadFis = (FileInputStream)payload;
            messageBytes = new byte[fis.available()];
            payloadBytes = new byte[payloadFis.available()];
            fis.read(messageBytes);
            payloadFis.read(payloadBytes);
        } else {
            FileMessageAdapterTestCase.fail((String)"FileMessageAdaptor supports File or FileInputStream");
        }
        FileMessageAdapterTestCase.assertTrue((boolean)Arrays.equals(messageBytes, payloadBytes));
    }
}

