/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileMessageReceiver;
import org.mule.util.FileUtils;

public class FileConnectorTestCase
extends AbstractConnectorTestCase {
    static final long POLLING_FREQUENCY = 1234L;
    static final long POLLING_FREQUENCY_OVERRIDE = 4321L;
    private File validMessage;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        File tempDir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)"tmp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        this.validMessage = File.createTempFile("simple", ".mule", tempDir);
        FileConnectorTestCase.assertNotNull((Object)this.validMessage);
        FileUtils.writeStringToFile((File)this.validMessage, (String)"validMessage");
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteTree((File)FileUtils.newFile((String)FileConnectorTestCase.getTestConnector().getProtocol()));
        super.doTearDown();
    }

    public Connector createConnector() throws Exception {
        FileConnector connector = new FileConnector();
        connector.setName("testFile");
        connector.setOutputAppend(true);
        return connector;
    }

    public String getTestEndpointURI() {
        return "file://" + muleContext.getConfiguration().getWorkingDirectory();
    }

    public Object getValidMessage() throws Exception {
        return this.validMessage;
    }

    public void testConnectorPollingFrequency() throws Exception {
        FileConnector connector = (FileConnector)this.getConnector();
        connector.setPollingFrequency(1234L);
        InboundEndpoint endpoint = FileConnectorTestCase.getTestInboundEndpoint((String)"simple");
        Service service = FileConnectorTestCase.getTestService();
        MessageReceiver receiver = connector.createReceiver(service, endpoint);
        FileConnectorTestCase.assertEquals((String)"Connector's polling frequency must not be ignored.", (long)1234L, (long)((FileMessageReceiver)receiver).getFrequency());
    }

    public void testPollingFrequencyEndpointOverride() throws Exception {
        FileConnector connector = (FileConnector)this.getConnector();
        connector.setPollingFrequency(-1L);
        InboundEndpoint endpoint = FileConnectorTestCase.getTestInboundEndpoint((String)"simple");
        endpoint.getProperties().put("pollingFrequency", String.valueOf(4321L));
        Service service = FileConnectorTestCase.getTestService();
        MessageReceiver receiver = connector.createReceiver(service, endpoint);
        FileConnectorTestCase.assertEquals((String)"Polling frequency endpoint override must not be ignored.", (long)4321L, (long)((FileMessageReceiver)receiver).getFrequency());
    }

    public void testOutputAppendEndpointOverride() throws Exception {
        FileConnector connector = (FileConnector)this.getConnector();
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(new URIBuilder("file://foo"), muleContext);
        OutboundEndpoint endpoint = endpointBuilder.buildOutboundEndpoint();
        endpoint.getProperties().put("outputAppend", "true");
        try {
            connector.getDispatcherFactory().create(endpoint);
            FileConnectorTestCase.fail((String)"outputAppend cannot be configured on File endpoints");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testOnlySingleDispatcherPerEndpoint() throws InitialisationException {
        FileConnector connector = (FileConnector)this.getConnector();
        FileConnectorTestCase.assertEquals((int)1, (int)connector.getMaxDispatchersActive());
        connector.setMaxDispatchersActive(2);
        FileConnectorTestCase.assertEquals((int)1, (int)connector.getMaxDispatchersActive());
    }
}

