/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.AbstractMuleTestCase;

public class FileEndpointTestCase
extends AbstractMuleTestCase {
    private EndpointURI newMuleEndpointURI(String text) throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI(text);
        uri.initialise();
        return uri;
    }

    public void testFileUrl() throws Exception {
        EndpointURI url = this.newMuleEndpointURI("file:///C:/temp?endpointName=fileEndpoint");
        FileEndpointTestCase.assertEquals((String)"file", (String)url.getScheme());
        FileEndpointTestCase.assertEquals((String)"/C:/temp", (String)url.getAddress());
        FileEndpointTestCase.assertNotNull((Object)url.getEndpointName());
        FileEndpointTestCase.assertEquals((String)"fileEndpoint", (String)url.getEndpointName());
        FileEndpointTestCase.assertEquals((int)-1, (int)url.getPort());
        FileEndpointTestCase.assertEquals((String)"file:///C:/temp?endpointName=fileEndpoint", (String)url.toString());
        FileEndpointTestCase.assertEquals((String)"endpointName=fileEndpoint", (String)url.getQuery());
        FileEndpointTestCase.assertEquals((int)1, (int)url.getParams().size());
    }

    public void testFileUrlWithoutDrive() throws Exception {
        EndpointURI url = this.newMuleEndpointURI("file://temp?endpointName=fileEndpoint");
        FileEndpointTestCase.assertEquals((String)"file", (String)url.getScheme());
        FileEndpointTestCase.assertEquals((String)"temp", (String)url.getAddress());
        FileEndpointTestCase.assertNotNull((Object)url.getEndpointName());
        FileEndpointTestCase.assertEquals((String)"fileEndpoint", (String)url.getEndpointName());
        FileEndpointTestCase.assertEquals((int)-1, (int)url.getPort());
        FileEndpointTestCase.assertEquals((String)"file://temp?endpointName=fileEndpoint", (String)url.toString());
        FileEndpointTestCase.assertEquals((String)"endpointName=fileEndpoint", (String)url.getQuery());
        FileEndpointTestCase.assertEquals((int)1, (int)url.getParams().size());
    }

    public void testRelativeFileUriParentDir() throws Exception {
        String muleURI = "file://../test-data/in";
        EndpointURI url = this.newMuleEndpointURI(muleURI);
        FileEndpointTestCase.assertEquals((String)"../test-data/in", (String)url.getAddress());
    }

    public void testRelativeFileUriCurrentDir() throws Exception {
        String muleURI = "file://./test-data/in";
        EndpointURI url = this.newMuleEndpointURI(muleURI);
        FileEndpointTestCase.assertEquals((String)"./test-data/in", (String)url.getAddress());
    }

    public void testWinNetworkUri() throws Exception {
        String muleURI = "file:////192.168.0.1/test/";
        EndpointURI url = this.newMuleEndpointURI(muleURI);
        FileEndpointTestCase.assertEquals((String)"//192.168.0.1/test/", (String)url.getAddress());
    }

    public void testRelativeFileUriAsParameter() throws Exception {
        EndpointURI url = this.newMuleEndpointURI("file://?address=./temp&endpointName=fileEndpoint");
        FileEndpointTestCase.assertEquals((String)"file", (String)url.getScheme());
        FileEndpointTestCase.assertEquals((String)"./temp", (String)url.getAddress());
        FileEndpointTestCase.assertNotNull((Object)url.getEndpointName());
        FileEndpointTestCase.assertEquals((String)"fileEndpoint", (String)url.getEndpointName());
        FileEndpointTestCase.assertEquals((int)-1, (int)url.getPort());
        FileEndpointTestCase.assertEquals((String)"file://?address=./temp&endpointName=fileEndpoint", (String)url.toString());
        FileEndpointTestCase.assertEquals((String)"address=./temp&endpointName=fileEndpoint", (String)url.getQuery());
        FileEndpointTestCase.assertEquals((int)2, (int)url.getParams().size());
    }
}

