/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import org.mule.api.transport.MessageAdapter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.DefaultMessageAdapter;
import org.mule.transport.file.SimpleFilenameParser;

public class SimpleFilenameParserTestCase
extends AbstractMuleTestCase {
    private SimpleFilenameParser parser;
    private MessageAdapter adapter;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.parser = new SimpleFilenameParser();
        this.adapter = new DefaultMessageAdapter((Object)"hello");
        this.adapter.setProperty("foo", (Object)"bar");
        this.adapter.setProperty("originalFilename", (Object)"originalName");
        this.adapter.setProperty("filename", (Object)"newName");
    }

    public void testAntStyleParsing() {
        String result = this.parser.getFilename(this.adapter, "Test1_${COUNT}.txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test1_0.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test2_${DATE:yyMMdd}.txt");
        SimpleFilenameParserTestCase.assertEquals((int)16, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test3_${DATE}.txt");
        SimpleFilenameParserTestCase.assertEquals((int)31, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test4_${SYSTIME}.txt");
        SimpleFilenameParserTestCase.assertFalse((boolean)result.equals("Test4_${SYSTIME}.txt"));
        result = this.parser.getFilename(this.adapter, "Test5_${UUID}.txt");
        SimpleFilenameParserTestCase.assertFalse((boolean)result.equals("Test5_${UUID}.txt"));
        result = this.parser.getFilename(this.adapter, "Test6_${COUNT}.txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test6_1.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test7_${ORIGINALNAME}.txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test7_originalName.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test8_${foo}.txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test8_bar.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test9_${xxx}.txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test9_${xxx}.txt", (String)result);
    }

    public void testSquareStyleParsing() {
        String result = this.parser.getFilename(this.adapter, "Test1_[COUNT].txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test1_0.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test2_[DATE:yyMMdd].txt");
        SimpleFilenameParserTestCase.assertEquals((String)("got result: " + result), (int)16, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test3_[DATE].txt");
        SimpleFilenameParserTestCase.assertEquals((String)("got result: '" + result), (int)31, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test4_[SYSTIME].txt");
        SimpleFilenameParserTestCase.assertFalse((boolean)result.equals("Test4_[SYSTIME].txt"));
        result = this.parser.getFilename(this.adapter, "Test5_[UUID].txt");
        SimpleFilenameParserTestCase.assertFalse((boolean)result.equals("Test5_[UUID].txt"));
        result = this.parser.getFilename(this.adapter, "Test6_[COUNT].txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test6_1.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test7_[ORIGINALNAME].txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test7_originalName.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test8_[foo].txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test8_bar.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test9_[xxx].txt");
        SimpleFilenameParserTestCase.assertEquals((String)"Test9_[xxx].txt", (String)result);
    }
}

