/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.MessageAdapter;
import org.mule.api.transport.OutputHandler;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public class FileMessageDispatcher
extends AbstractMessageDispatcher {
    private final FileConnector connector;

    public FileMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (FileConnector)endpoint.getConnector();
        if (endpoint.getProperty((Object)"outputAppend") != null) {
            throw new IllegalArgumentException("configuring outputAppend on the file endpoint is no longer support. You can configure a the File connector instead.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(MuleEvent event) throws Exception {
        Object data = event.transformMessage();
        DefaultMuleMessage message = new DefaultMuleMessage(data, (MessageAdapter)event.getMessage());
        FileOutputStream fos = (FileOutputStream)this.connector.getOutputStream(event.getEndpoint(), (MuleMessage)message);
        try {
            if (event.getMessage().getStringProperty("filename", null) == null) {
                event.getMessage().setStringProperty("filename", message.getStringProperty("filename", ""));
            }
            if (data instanceof byte[]) {
                fos.write((byte[])data);
            } else if (data instanceof String) {
                fos.write(data.toString().getBytes(event.getEncoding()));
            } else if (data instanceof OutputHandler) {
                ((OutputHandler)data).write(event, (OutputStream)fos);
            } else {
                InputStream is = (InputStream)event.transformMessage(InputStream.class);
                IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
                is.close();
            }
        }
        finally {
            this.logger.debug((Object)"Closing file");
            fos.close();
        }
    }

    public Object getDelegateSession() throws MuleException {
        return null;
    }

    protected static File getNextFile(String dir, FilenameFilter filter) throws MuleException {
        File file = FileUtils.newFile((String)dir);
        File result = null;
        try {
            if (file.exists()) {
                File[] files;
                if (file.isFile()) {
                    result = file;
                } else if (file.isDirectory() && (files = filter != null ? file.listFiles(filter) : file.listFiles()).length > 0) {
                    result = files[0];
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new DefaultMuleException(FileMessages.errorWhileListingFiles(), (Throwable)e);
        }
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

