/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.File;
import junit.framework.Assert;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.object.ObjectFactory;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.component.DefaultJavaComponent;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.model.seda.SedaService;
import org.mule.object.SingletonObjectFactory;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transformer.NoActionTransformer;
import org.mule.transport.file.AbstractFileMoveDeleteTestCase;
import org.mule.transport.file.FileContentsMessageAdapter;
import org.mule.transport.file.FileMessageAdapter;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.util.concurrent.Latch;

public class FileReceiverMoveDeleteTestCase
extends AbstractFileMoveDeleteTestCase {
    public void testMoveAndDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, true, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, true, true);
    }

    public void testMoveOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, false, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, true, false);
    }

    public void testDeleteOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, true, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, false, true);
    }

    public void testNoMoveNoDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, false, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, false, false);
    }

    public void testMoveAndDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, true, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, true, true);
    }

    public void testMoveOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, true, false);
    }

    public void testDeleteOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, true, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, false, true);
    }

    public void testNoMoveNoDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, false, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, false, false);
    }

    public void testMoveAndDeleteFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, FileMessageAdapter.class);
    }

    public void testMoveOnlyFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, FileMessageAdapter.class);
    }

    public void testDeleteOnlyFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, true, FileMessageAdapter.class);
    }

    public void testNoMoveNoDeleteFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, false, FileMessageAdapter.class);
        this.assertFiles(inFile, moveToDir, false, false);
    }

    protected Latch configureService(File inFile, boolean streaming, boolean filePayload) throws Exception {
        SedaService s = new SedaService();
        s.setName("moveDeleteBridgeService");
        String url = this.fileToUrl(inFile.getParentFile()) + "?connector=moveDeleteConnector";
        FileMessageAdaptorAssertingTransformer transformer = null;
        if (streaming) {
            if (filePayload) {
                FileReceiverMoveDeleteTestCase.fail((String)"Inconsistant test case: streaming and file payload are not compatible");
            } else {
                transformer = new FileMessageAdaptorAssertingTransformer(FileMessageAdapter.class, ReceiverFileInputStream.class);
            }
        } else {
            transformer = filePayload ? new FileMessageAdaptorAssertingTransformer(FileMessageAdapter.class, File.class) : new FileMessageAdaptorAssertingTransformer(FileContentsMessageAdapter.class, byte[].class);
        }
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(new URIBuilder(url), muleContext);
        endpointBuilder.addTransformer((Transformer)transformer);
        if (filePayload) {
            endpointBuilder.addTransformer((Transformer)new NoActionTransformer());
        }
        endpointBuilder.setSynchronous(true);
        s.getInboundRouter().addEndpoint(muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint((EndpointBuilder)endpointBuilder));
        final Latch latch = new Latch();
        FunctionalTestComponent component = new FunctionalTestComponent();
        component.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object message) throws Exception {
                Assert.assertEquals((long)1L, (long)latch.getCount());
                latch.countDown();
                Assert.assertEquals((String)"Test file contents", (String)context.transformMessageToString());
            }
        });
        component.initialise();
        s.setComponent((Component)new DefaultJavaComponent((ObjectFactory)new SingletonObjectFactory((Object)component)));
        s.setModel(muleContext.getRegistry().lookupSystemModel());
        muleContext.getRegistry().registerService((Service)s);
        s.start();
        return latch;
    }

    protected void assertRecevied(Latch latch) throws Exception {
        FileReceiverMoveDeleteTestCase.assertTrue((latch != null && latch.await(2000L, TimeUnit.MILLISECONDS) ? 1 : 0) != 0);
    }

    private class FileMessageAdaptorAssertingTransformer
    extends AbstractMessageAwareTransformer {
        private Class expectedMessageAdaptor;
        private Class expectedPayload;

        public FileMessageAdaptorAssertingTransformer(Class expectedMessageAdaptor, Class expectedPayload) {
            this.expectedMessageAdaptor = expectedMessageAdaptor;
            this.expectedPayload = expectedPayload;
        }

        public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
            Assert.assertEquals((Object)this.expectedMessageAdaptor, message.getAdapter().getClass());
            Assert.assertEquals((Object)this.expectedPayload, message.getAdapter().getPayload().getClass());
            if (this.expectedMessageAdaptor.equals(FileMessageAdapter.class)) {
                FileReceiverMoveDeleteTestCase.this.assertFilesUntouched(((FileMessageAdapter)message.getAdapter()).file);
            }
            return message;
        }
    }
}

