/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.transformers;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transport.file.transformers.FileToByteArray;
import org.mule.util.FileUtils;
import org.mule.util.SystemUtils;

public class FileToByteArrayTestCase
extends AbstractTransformerTestCase {
    FileToByteArray _fts;
    File _testFile = null;
    byte[] _resultData;
    final String _testString = "The dog is on the table, where's the dog?";

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this._resultData = "The dog is on the table, where's the dog?".getBytes(muleContext.getConfiguration().getDefaultEncoding());
        this._testFile = FileUtils.newFile((String)SystemUtils.JAVA_IO_TMPDIR, (String)"FileToStringTestData");
        FileWriter fw = new FileWriter(this._testFile);
        fw.write("The dog is on the table, where's the dog?");
        fw.close();
    }

    protected void doTearDown() throws Exception {
        FileToByteArrayTestCase.assertTrue((boolean)this._testFile.delete());
        super.doTearDown();
    }

    public Transformer getTransformer() throws Exception {
        return new FileToByteArray();
    }

    public Object getResultData() {
        return this._resultData;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    public Object getTestData() {
        return this._testFile;
    }

    public void testTransformInputStream() throws TransformerException, Exception {
        FileInputStream fis = new FileInputStream(this._testFile);
        FileToByteArrayTestCase.assertTrue((boolean)Arrays.equals((byte[])this._resultData, (byte[])((byte[])this.getTransformer().transform((Object)fis))));
    }

    public void testTransformByteArray() throws TransformerException, Exception {
        FileInputStream fis = new FileInputStream(this._testFile);
        byte[] bytes = new byte[new Long(this._testFile.length()).intValue()];
        fis.read(bytes);
        FileToByteArrayTestCase.assertTrue((boolean)Arrays.equals((byte[])this._resultData, (byte[])((byte[])this.getTransformer().transform((Object)bytes))));
    }

    public void testTransformString() throws TransformerException, Exception {
        FileToByteArrayTestCase.assertTrue((boolean)Arrays.equals((byte[])this._resultData, (byte[])((byte[])this.getTransformer().transform((Object)"The dog is on the table, where's the dog?"))));
    }
}

