/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.FileInputStream;
import java.io.InputStream;
import org.mule.api.MessagingException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.ThreadSafeAccess;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.file.FileMessageAdapter;
import org.mule.util.IOUtils;

public class FileContentsMessageAdapter
extends FileMessageAdapter {
    private static final long serialVersionUID = 7368719494535568721L;
    private byte[] contents = null;

    public FileContentsMessageAdapter(Object message) throws MessagingException {
        super(message);
        this.getPayload();
    }

    public FileContentsMessageAdapter(FileContentsMessageAdapter template) {
        super(template);
        this.contents = template.contents;
        this.getPayload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPayload() {
        if (this.contents == null) {
            FileContentsMessageAdapter fileContentsMessageAdapter = this;
            synchronized (fileContentsMessageAdapter) {
                try {
                    if (this.fileInputStream == null) {
                        this.fileInputStream = new FileInputStream(this.file);
                    }
                    this.contents = IOUtils.toByteArray((InputStream)this.fileInputStream);
                    this.fileInputStream.close();
                    this.fileInputStream = null;
                }
                catch (Exception noPayloadException) {
                    throw new MuleRuntimeException(CoreMessages.failedToReadPayload(), (Throwable)noPayloadException);
                }
            }
        }
        return this.contents;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new FileContentsMessageAdapter(this);
    }
}

