/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.DefaultMessageAdapter;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileMessageDispatcher;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;

public class FileMessageRequester
extends AbstractMessageRequester {
    private final FileConnector connector;
    private FilenameFilter filenameFilter = null;
    private FileFilter fileFilter = null;

    public FileMessageRequester(InboundEndpoint endpoint) throws MuleException {
        super(endpoint);
        this.connector = (FileConnector)endpoint.getConnector();
        Filter filter = endpoint.getFilter();
        if (filter instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)filter;
        } else if (filter instanceof FileFilter) {
            this.fileFilter = (FileFilter)filter;
        } else if (filter != null) {
            throw new CreateException(FileMessages.invalidFileFilter(endpoint.getEndpointURI()), (Object)this);
        }
    }

    public Object getDelegateSession() throws MuleException {
        return null;
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        File file = FileUtils.newFile((String)this.endpoint.getEndpointURI().getAddress());
        File result = null;
        if (file.exists()) {
            if (file.isFile()) {
                result = file;
            } else if (file.isDirectory()) {
                result = this.fileFilter != null ? FileMessageDispatcher.getNextFile(this.endpoint.getEndpointURI().getAddress(), this.fileFilter) : FileMessageDispatcher.getNextFile(this.endpoint.getEndpointURI().getAddress(), this.filenameFilter);
            }
            if (result != null) {
                boolean checkFileAge = this.connector.getCheckFileAge();
                if (checkFileAge) {
                    long fileAge = this.connector.getFileAge();
                    long lastMod = result.lastModified();
                    long now = System.currentTimeMillis();
                    long thisFileAge = now - lastMod;
                    if (thisFileAge < fileAge) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + result.getCanonicalPath()));
                        }
                        return null;
                    }
                }
                String sourceFileOriginalName = result.getName();
                DefaultMessageAdapter fileParserMsgAdaptor = new DefaultMessageAdapter(null);
                fileParserMsgAdaptor.setProperty("originalFilename", (Object)sourceFileOriginalName);
                File destinationFile = null;
                String movDir = this.connector.getMoveToDirectory();
                if (movDir != null) {
                    String destinationFileName = sourceFileOriginalName;
                    String moveToPattern = this.connector.getMoveToPattern();
                    if (moveToPattern != null) {
                        destinationFileName = this.connector.getFilenameParser().getFilename((MessageAdapter)fileParserMsgAdaptor, moveToPattern);
                    }
                    destinationFile = FileUtils.newFile((String)movDir, (String)destinationFileName);
                }
                MessageAdapter msgAdapter = null;
                try {
                    msgAdapter = this.connector.isStreaming() ? this.connector.getMessageAdapter(new ReceiverFileInputStream(result, this.connector.isAutoDelete(), destinationFile)) : this.connector.getMessageAdapter(result);
                }
                catch (FileNotFoundException e) {
                    this.logger.error((Object)"File being read disappeared!", (Throwable)e);
                    return null;
                }
                msgAdapter.setProperty("originalFilename", (Object)sourceFileOriginalName);
                if (!this.connector.isStreaming()) {
                    this.moveOrDelete(result, destinationFile);
                    return new DefaultMuleMessage((Object)msgAdapter);
                }
                return new DefaultMuleMessage((Object)msgAdapter);
            }
        }
        return null;
    }

    private void moveOrDelete(File sourceFile, File destinationFile) throws DefaultMuleException {
        if (destinationFile != null && !FileUtils.moveFile((File)sourceFile, (File)destinationFile)) {
            throw new DefaultMuleException(FileMessages.failedToMoveFile(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()));
        }
        if (this.connector.isAutoDelete() && destinationFile == null && !sourceFile.delete()) {
            throw new DefaultMuleException(FileMessages.failedToDeleteFile(sourceFile));
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

