/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.DefaultMessageAdapter;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;

public class FileMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final String COMPARATOR_CLASS_NAME_PROPERTY = "comparator";
    public static final String COMPARATOR_REVERSE_ORDER_PROPERTY = "reverseOrder";
    private static final File[] NO_FILES = new File[0];
    private String readDir = null;
    private String moveDir = null;
    private File readDirectory = null;
    private File moveDirectory = null;
    private String moveToPattern = null;
    private FilenameFilter filenameFilter = null;
    private FileFilter fileFilter = null;

    public FileMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint, String readDir, String moveDir, String moveToPattern, long frequency) throws CreateException {
        super(connector, service, endpoint);
        this.setFrequency(frequency);
        this.readDir = readDir;
        this.moveDir = moveDir;
        this.moveToPattern = moveToPattern;
        if (endpoint.getFilter() instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)endpoint.getFilter();
        } else if (endpoint.getFilter() instanceof FileFilter) {
            this.fileFilter = (FileFilter)endpoint.getFilter();
        } else if (endpoint.getFilter() != null) {
            throw new CreateException(FileMessages.invalidFileFilter(endpoint.getEndpointURI()), (Object)this);
        }
    }

    protected void doConnect() throws Exception {
        if (this.readDir != null) {
            this.readDirectory = FileUtils.openDirectory((String)this.readDir);
            if (!this.readDirectory.canRead()) {
                throw new ConnectException(FileMessages.fileDoesNotExist(this.readDirectory.getAbsolutePath()), (Object)this);
            }
            this.logger.debug((Object)("Listening on endpointUri: " + this.readDirectory.getAbsolutePath()));
        }
        if (this.moveDir != null) {
            this.moveDirectory = FileUtils.openDirectory((String)this.moveDir);
            if (!this.moveDirectory.canRead() || !this.moveDirectory.canWrite()) {
                throw new ConnectException(FileMessages.moveToDirectoryNotWritable(), (Object)this);
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    public void poll() {
        try {
            Comparator comparator;
            Object[] files = this.listFiles();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Files: " + Arrays.toString((Object[])files)));
            }
            if ((comparator = this.getComparator()) != null) {
                Arrays.sort((Object[])files, (Comparator)comparator);
            }
            for (Object file : files) {
                if (!((File)file).isFile()) continue;
                this.processFile((File)file);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void processFile(File sourceFile) throws MuleException {
        MessageAdapter msgAdapter;
        boolean checkFileAge = ((FileConnector)this.connector).getCheckFileAge();
        if (checkFileAge) {
            long fileAge = ((FileConnector)this.connector).getFileAge();
            long lastMod = sourceFile.lastModified();
            long now = System.currentTimeMillis();
            long thisFileAge = now - lastMod;
            if (thisFileAge < fileAge) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + sourceFile));
                }
                return;
            }
        }
        if (!this.attemptFileLock(sourceFile)) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Lock obtained on file: " + sourceFile.getAbsolutePath()));
        }
        FileConnector fc = (FileConnector)this.connector;
        String sourceFileOriginalName = sourceFile.getName();
        if (!(sourceFile.canRead() && sourceFile.exists() && sourceFile.isFile())) {
            throw new DefaultMuleException(FileMessages.fileDoesNotExist(sourceFileOriginalName));
        }
        DefaultMessageAdapter fileParserMsgAdaptor = new DefaultMessageAdapter(null);
        fileParserMsgAdaptor.setProperty("originalFilename", (Object)sourceFileOriginalName);
        File destinationFile = null;
        if (this.moveDir != null) {
            String destinationFileName = sourceFileOriginalName;
            if (this.moveToPattern != null) {
                destinationFileName = ((FileConnector)this.connector).getFilenameParser().getFilename((MessageAdapter)fileParserMsgAdaptor, this.moveToPattern);
            }
            destinationFile = FileUtils.newFile((String)this.moveDir, (String)destinationFileName);
        }
        try {
            msgAdapter = fc.isStreaming() ? this.connector.getMessageAdapter((Object)new ReceiverFileInputStream(sourceFile, fc.isAutoDelete(), destinationFile)) : this.connector.getMessageAdapter((Object)sourceFile);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"File being read disappeared!", (Throwable)e);
            return;
        }
        msgAdapter.setProperty("originalFilename", (Object)sourceFileOriginalName);
        if (!fc.isStreaming()) {
            this.moveAndDelete(sourceFile, destinationFile, sourceFileOriginalName, msgAdapter);
        } else {
            this.routeMessage((MuleMessage)new DefaultMuleMessage((Object)msgAdapter, this.connector.getMuleContext()), this.endpoint.isSynchronous());
        }
    }

    private void moveAndDelete(File sourceFile, File destinationFile, String sourceFileOriginalName, MessageAdapter msgAdapter) {
        boolean fileWasMoved = false;
        try {
            if (destinationFile != null) {
                try {
                    FileUtils.moveFile((File)sourceFile, (File)destinationFile);
                }
                catch (IOException e) {
                    throw new DefaultMuleException(FileMessages.failedToMoveFile(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()));
                }
                msgAdapter = this.connector.getMessageAdapter((Object)destinationFile);
                msgAdapter.setProperty("filename", (Object)destinationFile.getName());
                msgAdapter.setProperty("originalFilename", (Object)sourceFileOriginalName);
            }
            this.routeMessage((MuleMessage)new DefaultMuleMessage((Object)msgAdapter, this.connector.getMuleContext()), this.endpoint.isSynchronous());
            if (((FileConnector)this.connector).isAutoDelete() && destinationFile == null && !sourceFile.delete()) {
                throw new DefaultMuleException(FileMessages.failedToDeleteFile(sourceFile));
            }
        }
        catch (Exception e) {
            boolean fileWasRolledBack = false;
            if (fileWasMoved) {
                try {
                    this.rollbackFileMove(destinationFile, sourceFile.getAbsolutePath());
                    fileWasRolledBack = true;
                }
                catch (IOException ioException) {
                    // empty catch block
                }
            }
            RoutingException ex = new RoutingException(FileMessages.exceptionWhileProcessing(sourceFile.getName(), fileWasRolledBack ? "successful" : "unsuccessful"), (MuleMessage)new DefaultMuleMessage((Object)msgAdapter, this.connector.getMuleContext()), this.endpoint, (Throwable)e);
            this.handleException((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attemptFileLock(File sourceFile) {
        FileLock lock = null;
        FileChannel channel = null;
        boolean fileCanBeLocked = false;
        try {
            channel = new RandomAccessFile(sourceFile, "rw").getChannel();
            lock = channel.tryLock();
        }
        catch (FileNotFoundException fnfe) {
            this.logger.warn((Object)("Unable to open " + sourceFile.getAbsolutePath()), (Throwable)fnfe);
        }
        catch (IOException e) {
        }
        finally {
            if (lock != null) {
                fileCanBeLocked = true;
                try {
                    lock.release();
                }
                catch (IOException e) {}
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {}
            }
        }
        return fileCanBeLocked;
    }

    File[] listFiles() throws MuleException {
        try {
            File[] todoFiles = this.fileFilter != null ? this.readDirectory.listFiles(this.fileFilter) : this.readDirectory.listFiles(this.filenameFilter);
            return todoFiles == null ? NO_FILES : todoFiles;
        }
        catch (Exception e) {
            throw new DefaultMuleException(FileMessages.errorWhileListingFiles(), (Throwable)e);
        }
    }

    protected void rollbackFileMove(File sourceFile, String destinationFilePath) throws IOException {
        try {
            FileUtils.moveFile((File)sourceFile, (File)FileUtils.newFile((String)destinationFilePath));
        }
        catch (IOException t) {
            this.logger.debug((Object)("rollback of file move failed: " + t.getMessage()));
            throw t;
        }
    }

    protected Comparator getComparator() throws Exception {
        Object o = this.getEndpoint().getProperty((Object)COMPARATOR_CLASS_NAME_PROPERTY);
        Object reverseProperty = this.getEndpoint().getProperty((Object)COMPARATOR_REVERSE_ORDER_PROPERTY);
        boolean reverse = false;
        if (o != null) {
            if (reverseProperty != null) {
                reverse = Boolean.valueOf((String)reverseProperty);
            }
            Class<?> clazz = Class.forName(o.toString());
            o = clazz.newInstance();
            return reverse ? new ReverseComparator((Comparator)o) : (Comparator)o;
        }
        return null;
    }
}

