/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapterTestCase;
import org.mule.transport.file.FileMessageAdapter;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.util.FileUtils;

public class FileMessageAdapterTestCase
extends AbstractMessageAdapterTestCase {
    private File message;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        File dir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)"tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.message = File.createTempFile("simple", ".mule", dir);
    }

    public Object getValidMessage() {
        return this.message;
    }

    public MessageAdapter createAdapter(Object payload) throws MuleException {
        return new FileMessageAdapter(payload);
    }

    public void testMessageRetrieval2() throws Exception {
        ReceiverFileInputStream msg = new ReceiverFileInputStream((File)this.getValidMessage(), false, null);
        MessageAdapter adapter = this.createAdapter(msg);
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)adapter, muleContext);
        this.doTestMessageEqualsPayload(msg, adapter.getPayload());
        byte[] bytes = muleMessage.getPayloadAsBytes();
        FileMessageAdapterTestCase.assertNotNull((Object)bytes);
        String stringMessage = muleMessage.getPayloadAsString();
        FileMessageAdapterTestCase.assertNotNull((Object)stringMessage);
        FileMessageAdapterTestCase.assertNotNull((Object)adapter.getPayload());
    }

    protected void doTestMessageEqualsPayload(Object msg, Object payload) throws Exception {
        if (msg instanceof File) {
            File file = (File)msg;
            FileMessageAdapterTestCase.assertTrue((boolean)(payload instanceof File));
            FileMessageAdapterTestCase.assertEquals((Object)file, (Object)payload);
        } else if (msg instanceof FileInputStream) {
            byte[] messageBytes = null;
            byte[] payloadBytes = null;
            FileInputStream fis = (FileInputStream)msg;
            FileInputStream payloadFis = (FileInputStream)payload;
            messageBytes = new byte[fis.available()];
            payloadBytes = new byte[payloadFis.available()];
            fis.read(messageBytes);
            payloadFis.read(payloadBytes);
            FileMessageAdapterTestCase.assertTrue((boolean)Arrays.equals(messageBytes, payloadBytes));
        } else {
            FileMessageAdapterTestCase.fail((String)"FileMessageAdaptor supports File or FileInputStream");
        }
    }

    public void testSerializationWithFile() throws Exception {
        MessageAdapter messageAdapter = this.createAdapter(this.getValidMessage());
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)messageAdapter, muleContext);
        this.serializeMessage((MuleMessage)muleMessage);
    }

    public void testSerializationWithInputStream() throws Exception {
        try {
            ReceiverFileInputStream inputStream = new ReceiverFileInputStream(this.message, false, this.message);
            MessageAdapter messageAdapter = this.createAdapter(inputStream);
            DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)messageAdapter, muleContext);
            this.serializeMessage((MuleMessage)muleMessage);
            FileMessageAdapterTestCase.fail((String)"serializing a ReceiverFileInputStream is not expected to work");
        }
        catch (SerializationException ex) {
            FileMessageAdapterTestCase.assertTrue((boolean)(ex.getCause() instanceof NotSerializableException));
        }
    }

    private void serializeMessage(MuleMessage muleMessage) throws Exception {
        byte[] serializedMessage = SerializationUtils.serialize((Serializable)muleMessage);
        DefaultMuleMessage readMessage = (DefaultMuleMessage)SerializationUtils.deserialize((byte[])serializedMessage);
        FileMessageAdapterTestCase.assertNotNull((Object)readMessage.getAdapter());
        MessageAdapter readMessageAdapter = readMessage.getAdapter();
        FileMessageAdapterTestCase.assertTrue((boolean)(readMessageAdapter instanceof FileMessageAdapter));
        FileMessageAdapterTestCase.assertEquals((Object)this.getValidMessage(), (Object)readMessageAdapter.getPayload());
    }
}

