/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import org.mule.api.transport.MessageAdapter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.DefaultMessageAdapter;
import org.mule.transport.file.ExpressionFilenameParser;

public class ExpressionFilenameParserTestCase
extends AbstractMuleTestCase {
    private ExpressionFilenameParser parser;
    private MessageAdapter adapter;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.parser = new ExpressionFilenameParser();
        this.parser.setMuleContext(muleContext);
        this.adapter = new DefaultMessageAdapter((Object)"hello");
        this.adapter.setProperty("foo", (Object)"bar");
        this.adapter.setProperty("originalFilename", (Object)"originalName");
        this.adapter.setProperty("filename", (Object)"newName");
    }

    public void testWigglyMuleStyleParsing() {
        String result = this.parser.getFilename(this.adapter, "Test1_#[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test1_0.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test2_#[function:datestamp-yyMMdd].txt");
        ExpressionFilenameParserTestCase.assertEquals((int)16, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test3_#[function:datestamp].txt");
        ExpressionFilenameParserTestCase.assertEquals((int)31, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test4_#[function:systime].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test4_#[function:systime].txt"));
        result = this.parser.getFilename(this.adapter, "Test5_#[function:uuid].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test5_#[function:uuid].txt"));
        result = this.parser.getFilename(this.adapter, "Test6_#[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test6_1.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test7_#[header:originalFilename].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test7_originalName.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test8_#[header:foo].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test8_bar.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test9_#[header:xxx?].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test9_#[header:xxx?].txt", (String)result);
        try {
            result = this.parser.getFilename(this.adapter, "Test9_#[header:xxx].txt");
            ExpressionFilenameParserTestCase.fail((String)"Property xxx is not available");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSquareStyleParsing() {
        String result = this.parser.getFilename(this.adapter, "Test1_[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test1_0.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test2_[function:dateStamp-yyMMdd].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)("got result: " + result), (int)16, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test3_[function:dateStamp].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)("got result: '" + result), (int)31, (int)result.length());
        result = this.parser.getFilename(this.adapter, "Test4_[function:systime].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test4_[function:systime].txt"));
        result = this.parser.getFilename(this.adapter, "Test5_[function:uuid].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test5_[function:uuid].txt"));
        result = this.parser.getFilename(this.adapter, "Test6_[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test6_1.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test7_[header:originalFilename].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test7_originalName.txt", (String)result);
        result = this.parser.getFilename(this.adapter, "Test8_[header:foo].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test8_bar.txt", (String)result);
        try {
            result = this.parser.getFilename(this.adapter, "Test9_[header:xxx].txt");
            ExpressionFilenameParserTestCase.fail((String)"Property xxx is not available");
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = this.parser.getFilename(this.adapter, "Test9_[header:xxx?].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test9_[header:xxx?].txt", (String)result);
    }
}

