/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.SerializationUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapterTestCase;
import org.mule.transport.file.FileContentsMessageAdapter;
import org.mule.util.FileUtils;

public class FileContentsMessageAdapterTestCase
extends AbstractMessageAdapterTestCase {
    private String validMessageContent = "Yabbadabbadooo!";
    private byte[] validMessage = this.validMessageContent.getBytes();
    private File messageFile;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        File dir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)"tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.messageFile = File.createTempFile("simple", ".mule", dir);
        FileUtils.writeStringToFile((File)this.messageFile, (String)this.validMessageContent, null);
    }

    public Object getValidMessage() {
        return this.validMessage;
    }

    public MessageAdapter createAdapter(Object payload) throws MuleException {
        if (payload.equals(this.validMessage)) {
            return new FileContentsMessageAdapter((Object)this.messageFile);
        }
        return new FileContentsMessageAdapter(payload);
    }

    public void testMessageContentsProperlyLoaded() throws Exception {
        FileContentsMessageAdapter adapter = new FileContentsMessageAdapter((Object)this.messageFile);
        FileContentsMessageAdapterTestCase.assertTrue((boolean)this.messageFile.delete());
        this.doTestMessageEqualsPayload(this.validMessage, adapter.getPayload());
    }

    public void testSerialization() throws Exception {
        MessageAdapter messageAdapter = this.createAdapter(this.messageFile);
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)messageAdapter, muleContext);
        byte[] serializedMessage = SerializationUtils.serialize((Serializable)muleMessage);
        DefaultMuleMessage readMessage = (DefaultMuleMessage)SerializationUtils.deserialize((byte[])serializedMessage);
        FileContentsMessageAdapterTestCase.assertNotNull((Object)readMessage.getAdapter());
        MessageAdapter readMessageAdapter = readMessage.getAdapter();
        FileContentsMessageAdapterTestCase.assertTrue((boolean)(readMessageAdapter instanceof FileContentsMessageAdapter));
        FileContentsMessageAdapterTestCase.assertTrue((boolean)Arrays.equals((byte[])this.getValidMessage(), (byte[])readMessageAdapter.getPayload()));
    }
}

