/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.util.HashMap;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileMessageRequester;

public class FileMessageRequesterTestCase
extends AbstractMuleTestCase {
    private static final String CONNECTOR_MOVE_DIR = "connector/moveto";
    private static final String ENDPOINT_MOVE_DIR = "endpoint/moveto";
    private static final String CONNECTOR_MOVE_TO_PATTERN = "#connector";
    private static final String ENDPOINT_MOVE_TO_PATTERN = "#endpoint";
    private FileConnector connector;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.connector = new FileConnector();
        this.connector.setMoveToDirectory(CONNECTOR_MOVE_DIR);
        this.connector.setMoveToPattern(CONNECTOR_MOVE_TO_PATTERN);
    }

    public void testMoveDirectoryFromConnector() throws Exception {
        FileMessageRequester requester = new FileMessageRequester(this.createEndpoint());
        FileMessageRequesterTestCase.assertEquals((String)CONNECTOR_MOVE_DIR, (String)requester.getMoveDirectory());
    }

    public void testMoveDirectoryFromEndpoint() throws Exception {
        InboundEndpoint endpoint = this.createEndpoint("moveToDirectory", ENDPOINT_MOVE_DIR);
        FileMessageRequester requester = new FileMessageRequester(endpoint);
        FileMessageRequesterTestCase.assertEquals((String)ENDPOINT_MOVE_DIR, (String)requester.getMoveDirectory());
    }

    public void testMoveToPatternFromConnector() throws Exception {
        FileMessageRequester requester = new FileMessageRequester(this.createEndpoint());
        FileMessageRequesterTestCase.assertEquals((String)CONNECTOR_MOVE_TO_PATTERN, (String)requester.getMoveToPattern());
    }

    public void testMoveToPatternFromEndpoint() throws Exception {
        InboundEndpoint endpoint = this.createEndpoint("moveToPattern", ENDPOINT_MOVE_TO_PATTERN);
        FileMessageRequester requester = new FileMessageRequester(endpoint);
        FileMessageRequesterTestCase.assertEquals((String)ENDPOINT_MOVE_TO_PATTERN, (String)requester.getMoveToPattern());
    }

    private InboundEndpoint createEndpoint() {
        return this.createEndpoint(null, null);
    }

    private InboundEndpoint createEndpoint(Object key, Object value) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        if (key != null) {
            properties.put(key, value);
        }
        return new DefaultInboundEndpoint((Connector)this.connector, null, null, null, null, properties, null, null, false, null, false, 42, null, null, null, muleContext, null);
    }
}

