/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.InputStream;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transport.Connector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.util.FileUtils;

public class AutoDeleteOnFileDispatcherReceiverTestCase
extends AbstractMuleTestCase {
    private File validMessage;
    private String tempDirName = "input";
    File tempDir;
    Connector connector;

    public void testAutoDeleteFalseOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(false);
        MuleEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((MuleEvent)event);
        MuleMessage message = RequestContext.getEventContext().requestEvent(this.getTestEndpointURI() + "/" + this.tempDirName + "?connector=FileConnector", 50000L);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)message.getPayloadAsString());
        File[] files = this.tempDir.listFiles();
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < files.length; ++i) {
            AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((boolean)files[i].getName().equals(message.getProperty("originalFilename")));
            files[i].delete();
        }
    }

    public void testAutoDeleteTrueOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(true);
        MuleEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((MuleEvent)event);
        MuleMessage message = RequestContext.getEventContext().requestEvent(this.getTestEndpointURI() + "/" + this.tempDirName, 50000L);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)message.getPayload());
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((boolean)(message.getPayload() instanceof InputStream));
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((this.tempDir.listFiles().length > 0 ? 1 : 0) != 0);
        ((InputStream)message.getPayload()).close();
        Thread.sleep(1000L);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertTrue((this.tempDir.listFiles().length == 0 ? 1 : 0) != 0);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tempDir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)this.tempDirName);
        this.tempDir.deleteOnExit();
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
        this.validMessage = File.createTempFile("hello", ".txt", this.tempDir);
        AutoDeleteOnFileDispatcherReceiverTestCase.assertNotNull((Object)this.validMessage);
        this.connector = this.getConnector();
        this.connector.start();
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteTree((File)FileUtils.newFile((String)AutoDeleteOnFileDispatcherReceiverTestCase.getTestConnector().getProtocol()));
        super.doTearDown();
    }

    public Connector getConnector() throws Exception {
        FileConnector connector = new FileConnector(muleContext);
        connector.setName("FileConnector");
        muleContext.getRegistry().registerConnector((Connector)connector);
        return connector;
    }

    public String getTestEndpointURI() {
        return "file://" + muleContext.getConfiguration().getWorkingDirectory();
    }
}

