/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.file.AbstractFileFunctionalTestCase;
import org.mule.transport.file.FileConnector;

public class FileFunctionalTestCase
extends AbstractFileFunctionalTestCase {
    public void testSend() throws Exception {
        File target = File.createTempFile("mule-file-test-", ".txt");
        target.deleteOnExit();
        FileConnector connector = (FileConnector)muleContext.getRegistry().lookupConnector("sendConnector");
        connector.setWriteToDirectory(target.getParent());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("TARGET_FILE", target.getName());
        MuleClient client = new MuleClient();
        client.dispatch("send", (Object)"Test file contents", props);
        this.waitForFileSystem();
        String result = new BufferedReader(new FileReader(target)).readLine();
        FileFunctionalTestCase.assertEquals((String)"Test file contents", (String)result);
    }

    public void testDirectRequest() throws Exception {
        File target = this.initForRequest();
        MuleClient client = new MuleClient();
        String url = this.fileToUrl(target) + "?connector=receiveConnector";
        this.logger.debug((Object)url);
        MuleMessage message = client.request(url, 100000L);
        this.checkReceivedMessage(message);
    }
}

