/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import org.mule.api.MuleEventContext;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.FileUtils;

public class WorkDirectoryTestCase
extends FunctionalTestCase {
    private static final String TEST_FILENAME = "test.txt";

    protected String getConfigResources() {
        return "work-directory-config.xml";
    }

    protected void doTearDown() throws Exception {
        File outputDir = new File(".mule");
        WorkDirectoryTestCase.assertTrue((boolean)FileUtils.deleteTree((File)outputDir));
        super.doTearDown();
    }

    public void testWorkDirectory() throws Exception {
        FunctionalTestComponent ftc = (FunctionalTestComponent)this.getComponent("relay");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                File workDir = new File(".mule/work");
                String[] filenames = workDir.list();
                Assert.assertTrue((filenames.length > 0 ? 1 : 0) != 0);
                for (String filename : filenames) {
                    if (!filename.contains(WorkDirectoryTestCase.TEST_FILENAME)) continue;
                    return;
                }
                Assert.fail((String)"no work dir file matching filename test.txt");
            }
        });
        this.writeTestMessageToInputDirectory();
        this.checkOutputDirectory();
    }

    private void writeTestMessageToInputDirectory() throws FileNotFoundException, IOException {
        File outFile = new File(".mule/in", TEST_FILENAME);
        FileOutputStream out = new FileOutputStream(outFile);
        out.write("Test Message".getBytes());
        out.close();
    }

    private void checkOutputDirectory() throws Exception {
        for (int i = 0; i < 30; ++i) {
            String[] filenames;
            File outDir = new File(".mule/out");
            if (outDir.exists() && (filenames = outDir.list()).length > 0) {
                for (String filename : filenames) {
                    if (!filename.contains(TEST_FILENAME)) continue;
                    return;
                }
            }
            Thread.sleep(1000L);
        }
        WorkDirectoryTestCase.fail((String)"no file with name test.txt in output directory");
    }
}

