/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.file.AbstractFileFunctionalTestCase;
import org.mule.transport.file.FileConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileMoveDeleteTestCase
extends AbstractFileFunctionalTestCase {
    protected File configureConnector(File inFile, boolean stream, boolean move, boolean delete, Class<? extends AbstractMuleMessageFactory> messageFactoryClass) throws Exception {
        FileConnector fc = new FileConnector(muleContext);
        if (messageFactoryClass != null) {
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("message.factory", messageFactoryClass.getName());
            fc.setServiceOverrides(overrides);
        }
        fc.setName("moveDeleteConnector");
        File moveToDir = new File(inFile.getParent() + "/moveto/");
        moveToDir.mkdir();
        muleContext.getRegistry().registerConnector((Connector)fc);
        if (move) {
            fc.setMoveToDirectory(moveToDir.getPath());
        }
        fc.setAutoDelete(delete);
        fc.setStreaming(stream);
        return moveToDir;
    }

    protected void assertFiles(File inFile, File moveToDir, boolean move, boolean delete) throws Exception {
        File movedFile;
        this.waitForFileSystem();
        boolean inFileShouldExst = !delete && !move;
        AbstractFileMoveDeleteTestCase.assertTrue((inFile.exists() == inFileShouldExst ? 1 : 0) != 0);
        if (inFileShouldExst) {
            AbstractFileMoveDeleteTestCase.assertEquals((String)"Test file contents", (String)new BufferedReader(new FileReader(inFile)).readLine());
        }
        AbstractFileMoveDeleteTestCase.assertTrue(((movedFile = new File(moveToDir.getPath() + "/" + inFile.getName())).exists() == move ? 1 : 0) != 0);
        if (move) {
            AbstractFileMoveDeleteTestCase.assertEquals((String)"Test file contents", (String)new BufferedReader(new FileReader(movedFile)).readLine());
        }
    }

    protected void assertFilesUntouched(File inFile) {
        AbstractFileMoveDeleteTestCase.assertTrue((boolean)inFile.exists());
        File movedFile = new File(inFile.getParent() + "/moveto/" + inFile.getName());
        AbstractFileMoveDeleteTestCase.assertFalse((boolean)movedFile.exists());
    }
}

