/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.filters;

import java.io.File;
import java.io.IOException;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.util.FileUtils;

public class FilterOnGlobalFileEndpointTestCase
extends FunctionalTestCase {
    private static final String TEXT_FILE = "sample.txt";
    private static final String XML_FILE = "sample.xml";
    private File pollDirectory;

    protected void doSetUp() throws Exception {
        this.createPollDirectoryAndInputFiles();
        super.doSetUp();
    }

    protected void doTearDown() throws Exception {
        FilterOnGlobalFileEndpointTestCase.assertTrue((boolean)FileUtils.deleteTree((File)this.pollDirectory.getParentFile()));
        super.doTearDown();
    }

    private void createPollDirectoryAndInputFiles() throws IOException {
        this.pollDirectory = this.createDirectory("target/FilterOnGlobalFileEndpointTestCase/testdir");
        this.createDirectory("target/FilterOnGlobalFileEndpointTestCase/testdir-moveto");
        this.createFileInPollDirectory(TEXT_FILE);
        this.createFileInPollDirectory(XML_FILE);
    }

    private File createDirectory(String path) {
        File directory = new File(path);
        if (!directory.exists() && !directory.mkdirs()) {
            FilterOnGlobalFileEndpointTestCase.fail((String)"could not create poll directory");
        }
        return directory;
    }

    private void createFileInPollDirectory(String filename) throws IOException {
        File file = FileUtils.newFile((File)this.pollDirectory, (String)filename);
        String path = file.getCanonicalPath();
        File newFile = FileUtils.createFile((String)path);
        newFile.deleteOnExit();
    }

    protected String getConfigResources() {
        return "global-file-ep-with-filter.xml";
    }

    public void testMoveFiles() throws Exception {
        File txtFile = new File(this.pollDirectory, TEXT_FILE);
        File xmlFile = new File(this.pollDirectory, XML_FILE);
        FilterOnGlobalFileEndpointTestCase.assertTrue((boolean)txtFile.exists());
        FilterOnGlobalFileEndpointTestCase.assertTrue((boolean)xmlFile.exists());
        MuleClient client = new MuleClient(muleContext);
        client.request("globalEP", 1000L);
        FilterOnGlobalFileEndpointTestCase.assertTrue((boolean)txtFile.exists());
        FilterOnGlobalFileEndpointTestCase.assertFalse((boolean)xmlFile.exists());
    }
}

