/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.file.AbstractFileFunctionalTestCase;
import org.mule.util.FileUtils;

public class FileEncodingFunctionalTestCase
extends AbstractFileFunctionalTestCase {
    private static final String TEST_MESSAGE_EUC_JP_ENCODED = "\u3053";
    private static final int FIVE_SECONDS_TIMEOUT = 5000;
    private static final String ENCODING = "EUC-JP";
    private File tmpDir;

    protected String getConfigResources() {
        return "file-encoding-test.xml";
    }

    public void testReadingFileWithEucJpEncodingGetsTheRightText() throws Exception {
        this.tmpDir = this.createFolder(".mule/mule-file-test-EUC-JP");
        this.createDataFile(this.tmpDir, ENCODING, TEST_MESSAGE_EUC_JP_ENCODED);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.request("vm://receive", 5000L);
        FileEncodingFunctionalTestCase.assertNotNull((Object)message);
        FileEncodingFunctionalTestCase.assertEquals((String)ENCODING, (String)message.getEncoding());
        FileEncodingFunctionalTestCase.assertEquals((String)TEST_MESSAGE_EUC_JP_ENCODED, (String)message.getPayloadAsString());
    }

    private File createDataFile(File folder, String encoding, String testMessage) throws Exception {
        File target = File.createTempFile("mule-file-test-", ".txt", folder);
        target.deleteOnExit();
        FileUtils.writeStringToFile((File)target, (String)testMessage, (String)encoding);
        return target;
    }

    private File createFolder(String name) {
        File result = FileUtils.newFile((String)name);
        result.delete();
        result.mkdir();
        result.deleteOnExit();
        return result;
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        FileUtils.deleteTree((File)this.tmpDir);
    }
}

