/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.i18n;

import java.io.File;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;

public class FileMessages
extends MessageFactory {
    private static final FileMessages factory = new FileMessages();
    private static final String BUNDLE_PATH = FileMessages.getBundlePath((String)"file");

    public static Message errorWhileListingFiles() {
        return factory.createMessage(BUNDLE_PATH, 1);
    }

    public static Message exceptionWhileProcessing(String name, String string) {
        return factory.createMessage(BUNDLE_PATH, 2, name, string);
    }

    public static Message failedToDeleteFile(File file) {
        return factory.createMessage(BUNDLE_PATH, 3, file.getAbsolutePath());
    }

    public static Message failedToMoveFile(String from, String to) {
        return factory.createMessage(BUNDLE_PATH, 4, from, to);
    }

    public static Message moveToDirectoryNotWritable() {
        return factory.createMessage(BUNDLE_PATH, 5);
    }

    public static Message invalidFileFilter(EndpointURI endpointURI) {
        return factory.createMessage(BUNDLE_PATH, 6, endpointURI);
    }

    public static Message fileDoesNotExist(String string) {
        return factory.createMessage(BUNDLE_PATH, 7, string);
    }

    public static Message invalidFilter(Object filter) {
        return factory.createMessage(BUNDLE_PATH, 8, filter.getClass().getName());
    }

    public static Message connectorAutodeletesWithoutConsuming(Connector connector) {
        return factory.createMessage(BUNDLE_PATH, 9, connector.getName());
    }
}

