/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.util.List;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.file.DummyFilenameParser;
import org.mule.transport.file.ExpressionFilenameParser;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FilenameParser;
import org.mule.transport.file.filters.FilenameRegexFilter;
import org.mule.transport.file.transformers.FileToByteArray;
import org.mule.transport.file.transformers.FileToString;
import org.mule.util.FileUtils;

public class FileNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "file-namespace-config.xml";
    }

    protected void doTearDown() throws Exception {
        File workDir = new File(".mule");
        FileNamespaceHandlerTestCase.assertTrue((boolean)FileUtils.deleteTree((File)workDir));
        super.doTearDown();
    }

    public void testConfig() throws Exception {
        FileConnector c = (FileConnector)muleContext.getRegistry().lookupConnector("fileConnector");
        FileNamespaceHandlerTestCase.assertNotNull((Object)c);
        FileNamespaceHandlerTestCase.assertEquals((long)1234L, (long)c.getFileAge());
        FileNamespaceHandlerTestCase.assertEquals((String)"abc", (String)c.getMoveToDirectory());
        FileNamespaceHandlerTestCase.assertEquals((String)"bcd", (String)c.getMoveToPattern());
        FileNamespaceHandlerTestCase.assertEquals((String)"cde", (String)c.getOutputPattern());
        FileNamespaceHandlerTestCase.assertEquals((long)2345L, (long)c.getPollingFrequency());
        FileNamespaceHandlerTestCase.assertEquals((String)".mule/readFromDirectory", (String)c.getReadFromDirectory());
        FileNamespaceHandlerTestCase.assertEquals((String)".mule/writeToDirectory", (String)c.getWriteToDirectory());
        FileNamespaceHandlerTestCase.assertEquals((String)".mule/workDirectory", (String)c.getWorkDirectory());
        FileNamespaceHandlerTestCase.assertEquals((String)"#[function:uuid]", (String)c.getWorkFileNamePattern());
        FileNamespaceHandlerTestCase.assertEquals((boolean)false, (boolean)c.isAutoDelete());
        FileNamespaceHandlerTestCase.assertEquals((boolean)true, (boolean)c.isOutputAppend());
        FileNamespaceHandlerTestCase.assertEquals((boolean)true, (boolean)c.isSerialiseObjects());
        FileNamespaceHandlerTestCase.assertEquals((boolean)false, (boolean)c.isStreaming());
        FileNamespaceHandlerTestCase.assertTrue((boolean)c.isRecursive());
        FilenameParser parser = c.getFilenameParser();
        FileNamespaceHandlerTestCase.assertTrue((String)parser.getClass().getName(), (boolean)(c.getFilenameParser() instanceof DummyFilenameParser));
        FileNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        FileNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
    }

    public void testThirdConnector() throws Exception {
        FileConnector c = (FileConnector)muleContext.getRegistry().lookupConnector("thirdConnector");
        FileNamespaceHandlerTestCase.assertNotNull((Object)c);
        FilenameParser parser = c.getFilenameParser();
        FileNamespaceHandlerTestCase.assertTrue((String)parser.getClass().getName(), (boolean)(c.getFilenameParser() instanceof ExpressionFilenameParser));
        FileNamespaceHandlerTestCase.assertTrue((boolean)c.isConnected());
        FileNamespaceHandlerTestCase.assertTrue((boolean)c.isStarted());
        FileNamespaceHandlerTestCase.assertFalse((boolean)c.isRecursive());
    }

    public void testTransformersOnEndpoints() throws Exception {
        Object transformer1 = muleContext.getEndpointFactory().getInboundEndpoint("ep1").getTransformers().get(0);
        FileNamespaceHandlerTestCase.assertNotNull(transformer1);
        FileNamespaceHandlerTestCase.assertEquals(FileToByteArray.class, transformer1.getClass());
        Object transformer2 = muleContext.getEndpointFactory().getInboundEndpoint("ep2").getTransformers().get(0);
        FileNamespaceHandlerTestCase.assertNotNull(transformer2);
        FileNamespaceHandlerTestCase.assertEquals(FileToString.class, transformer2.getClass());
    }

    public void testFileFilter() throws Exception {
        Service service = muleContext.getRegistry().lookupService("Test");
        FileNamespaceHandlerTestCase.assertNotNull((Object)service);
        List endpoints = ((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints();
        FileNamespaceHandlerTestCase.assertEquals((int)1, (int)endpoints.size());
        InboundEndpoint endpoint = (InboundEndpoint)endpoints.get(0);
        Filter filter = endpoint.getFilter();
        FileNamespaceHandlerTestCase.assertNotNull((Object)filter);
        FileNamespaceHandlerTestCase.assertTrue((boolean)(filter instanceof FilenameRegexFilter));
        FilenameRegexFilter f = (FilenameRegexFilter)filter;
        FileNamespaceHandlerTestCase.assertEquals((boolean)false, (boolean)f.isCaseSensitive());
        FileNamespaceHandlerTestCase.assertEquals((String)"(^SemDirector_Report-\\d)(.*)(tab$)", (String)f.getPattern());
    }
}

