/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.transformers;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import org.mule.api.transformer.Transformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transport.file.transformers.FileToByteArray;
import org.mule.util.FileUtils;
import org.mule.util.SystemUtils;

public class FileToByteArrayTestCase
extends AbstractTransformerTestCase {
    private static final String TEST_STRING = "The dog is on the table, where's the dog?";
    private File testFile;
    private byte[] resultData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.resultData = TEST_STRING.getBytes(muleContext.getConfiguration().getDefaultEncoding());
        this.testFile = FileUtils.newFile((String)SystemUtils.JAVA_IO_TMPDIR, (String)"FileToStringTestData");
        FileWriter fw = new FileWriter(this.testFile);
        try {
            fw.write(TEST_STRING);
        }
        finally {
            fw.close();
        }
    }

    protected void doTearDown() throws Exception {
        FileToByteArrayTestCase.assertTrue((boolean)this.testFile.delete());
        super.doTearDown();
    }

    public Transformer getTransformer() throws Exception {
        return new FileToByteArray();
    }

    public Object getResultData() {
        return this.resultData;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    public Object getTestData() {
        return this.testFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransformInputStream() throws Exception {
        FileInputStream fis = new FileInputStream(this.testFile);
        try {
            FileToByteArrayTestCase.assertTrue((boolean)Arrays.equals((byte[])this.resultData, (byte[])((byte[])this.getTransformer().transform((Object)fis))));
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransformByteArray() throws Exception {
        FileInputStream fis = new FileInputStream(this.testFile);
        byte[] bytes = new byte[(int)this.testFile.length()];
        try {
            int count;
            while ((count = fis.read(bytes)) != -1) {
            }
            FileToByteArrayTestCase.assertTrue((boolean)Arrays.equals((byte[])this.resultData, (byte[])((byte[])this.getTransformer().transform((Object)bytes))));
        }
        finally {
            fis.close();
        }
    }

    public void testTransformString() throws Exception {
        FileToByteArrayTestCase.assertTrue((boolean)Arrays.equals((byte[])this.resultData, (byte[])((byte[])this.getTransformer().transform((Object)TEST_STRING))));
    }
}

