/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.util.Date;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.file.ExpressionFilenameParser;

public class ExpressionFilenameParserTestCase
extends AbstractMuleTestCase {
    private ExpressionFilenameParser parser;
    private MuleMessage message;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.parser = new ExpressionFilenameParser();
        this.parser.setMuleContext(muleContext);
        this.message = new DefaultMuleMessage((Object)"hello", muleContext);
        this.message.setOutboundProperty("foo", (Object)"bar");
        this.message.setOutboundProperty("originalFilename", (Object)"originalName");
        this.message.setOutboundProperty("filename", (Object)"newName");
    }

    public void testWigglyMuleStyleParsing() {
        String result = this.parser.getFilename(this.message, "Test1_#[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test1_0.txt", (String)result);
        result = this.parser.getFilename(this.message, "Test2_#[function:datestamp-yyMMdd].txt");
        this.assertDatestampWithYearMonthAndDayMatches(result);
        result = this.parser.getFilename(this.message, "Test3_#[function:datestamp].txt");
        this.assertDefaultDatestampMatches(result);
        result = this.parser.getFilename(this.message, "Test4_#[function:systime].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test4_#[function:systime].txt"));
        result = this.parser.getFilename(this.message, "Test5_#[function:uuid].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test5_#[function:uuid].txt"));
        result = this.parser.getFilename(this.message, "Test6_#[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test6_1.txt", (String)result);
        result = this.parser.getFilename(this.message, "Test7_#[header:originalFilename].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test7_originalName.txt", (String)result);
        result = this.parser.getFilename(this.message, "Test8_#[header:foo].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test8_bar.txt", (String)result);
        result = this.parser.getFilename(this.message, "Test9_#[header:xxx?].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test9_#[header:xxx?].txt", (String)result);
        try {
            result = this.parser.getFilename(this.message, "Test9_#[header:xxx].txt");
            ExpressionFilenameParserTestCase.fail((String)"Property xxx is not available");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSquareStyleParsing() {
        String result = this.parser.getFilename(this.message, "Test1_[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test1_0.txt", (String)result);
        result = this.parser.getFilename(this.message, "Test2_[function:dateStamp-yyMMdd].txt");
        this.assertDatestampWithYearMonthAndDayMatches(result);
        result = this.parser.getFilename(this.message, "Test3_[function:dateStamp].txt");
        this.assertDefaultDatestampMatches(result);
        result = this.parser.getFilename(this.message, "Test4_[function:systime].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test4_[function:systime].txt"));
        result = this.parser.getFilename(this.message, "Test5_[function:uuid].txt");
        ExpressionFilenameParserTestCase.assertFalse((boolean)result.equals("Test5_[function:uuid].txt"));
        result = this.parser.getFilename(this.message, "Test6_[function:count].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test6_1.txt", (String)result);
        result = this.parser.getFilename(this.message, "Test7_[header:originalFilename].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test7_originalName.txt", (String)result);
        result = this.parser.getFilename(this.message, "Test8_[header:foo].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test8_bar.txt", (String)result);
        try {
            result = this.parser.getFilename(this.message, "Test9_[header:xxx].txt");
            ExpressionFilenameParserTestCase.fail((String)"Property xxx is not available");
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = this.parser.getFilename(this.message, "Test9_[header:xxx?].txt");
        ExpressionFilenameParserTestCase.assertEquals((String)"Test9_[header:xxx?].txt", (String)result);
    }

    private void assertDatestampWithYearMonthAndDayMatches(String result) {
        Date now = new Date();
        String expected = String.format("Test2_%1$ty%1$tm%1$td.txt", now);
        ExpressionFilenameParserTestCase.assertEquals((String)expected, (String)result);
    }

    private void assertDefaultDatestampMatches(String result) {
        Date now = new Date();
        String expected = String.format("Test3_%1$td-%1$tm-%1$ty_%1$tH-%1$tM-.*.txt", now);
        ExpressionFilenameParserTestCase.assertTrue((boolean)result.matches(expected));
    }
}

