/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.file.AbstractFileFunctionalTestCase;

public class FileEncodingFunctionalTestCase
extends AbstractFileFunctionalTestCase {
    private static final String TEST_MESSAGE_EUC_JP_ENCODED = "\u3053";
    private static final int FIVE_SECONDS_TIMEOUT = 5000;
    private static final String ENCODING = "EUC-JP";

    @Override
    protected String getConfigResources() {
        return "file-encoding-test.xml";
    }

    public void testReadingFileWithEucJpEncodingGetsTheRightText() throws Exception {
        this.tmpDir = this.createFolder(".mule/mule-file-test-EUC-JP");
        this.createDataFile(this.tmpDir, TEST_MESSAGE_EUC_JP_ENCODED, ENCODING);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.request("vm://receive", 5000L);
        FileEncodingFunctionalTestCase.assertNotNull((Object)message);
        FileEncodingFunctionalTestCase.assertEquals((String)ENCODING, (String)message.getEncoding());
        FileEncodingFunctionalTestCase.assertEquals((String)TEST_MESSAGE_EUC_JP_ENCODED, (String)message.getPayloadAsString());
    }
}

