/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.reliability;

import java.io.File;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.file.AbstractFileMoveDeleteTestCase;

public class InboundMessageLossTestCase
extends AbstractFileMoveDeleteTestCase {
    protected Prober prober = new PollingProber(10000L, 100L);

    @Override
    protected String getConfigResources() {
        return "reliability/inbound-message-loss.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((DefaultSystemExceptionStrategy)muleContext.getExceptionListener()).setRollbackTxFilter(new WildcardFilter("*"));
    }

    public void testNoException() throws Exception {
        this.tmpDir = this.createFolder(".mule/noException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    public void testTransformerException() throws Exception {
        this.tmpDir = this.createFolder(".mule/transformerException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return file.exists();
            }

            public String describeFailure() {
                return "File should have been restored";
            }
        });
    }

    public void testRouterException() throws Exception {
        this.tmpDir = this.createFolder(".mule/routerException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return file.exists();
            }

            public String describeFailure() {
                return "File should have been restored";
            }
        });
    }

    public void testComponentException() throws Exception {
        this.tmpDir = this.createFolder(".mule/componentException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }
}

