/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.construct.Flow;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.file.DummyFilenameParser;
import org.mule.transport.file.ExpressionFilenameParser;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FilenameParser;
import org.mule.transport.file.filters.FilenameRegexFilter;
import org.mule.transport.file.transformers.FileToByteArray;
import org.mule.transport.file.transformers.FileToString;
import org.mule.util.FileUtils;

public class FileNamespaceHandlerTestCase
extends AbstractServiceAndFlowTestCase {
    public FileNamespaceHandlerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "file-namespace-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "file-namespace-config-flow.xml"});
    }

    protected void doTearDown() throws Exception {
        File workDir = new File(".mule");
        Assert.assertTrue((boolean)FileUtils.deleteTree((File)workDir));
        super.doTearDown();
    }

    @Test
    public void testConfig() throws Exception {
        FileConnector c = (FileConnector)muleContext.getRegistry().lookupConnector("fileConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1234L, (long)c.getFileAge());
        Assert.assertEquals((Object)"abc", (Object)c.getMoveToDirectory());
        Assert.assertEquals((Object)"bcd", (Object)c.getMoveToPattern());
        Assert.assertEquals((Object)"cde", (Object)c.getOutputPattern());
        Assert.assertEquals((long)2345L, (long)c.getPollingFrequency());
        Assert.assertEquals((Object)".mule/readFromDirectory", (Object)c.getReadFromDirectory());
        Assert.assertEquals((Object)".mule/writeToDirectory", (Object)c.getWriteToDirectory());
        Assert.assertEquals((Object)".mule/workDirectory", (Object)c.getWorkDirectory());
        Assert.assertEquals((Object)"#[function:uuid]", (Object)c.getWorkFileNamePattern());
        Assert.assertEquals((Object)false, (Object)c.isAutoDelete());
        Assert.assertEquals((Object)true, (Object)c.isOutputAppend());
        Assert.assertEquals((Object)true, (Object)c.isSerialiseObjects());
        Assert.assertEquals((Object)false, (Object)c.isStreaming());
        Assert.assertTrue((boolean)c.isRecursive());
        FilenameParser parser = c.getFilenameParser();
        Assert.assertTrue((String)parser.getClass().getName(), (boolean)(c.getFilenameParser() instanceof DummyFilenameParser));
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
    }

    @Test
    public void testThirdConnector() throws Exception {
        FileConnector c = (FileConnector)muleContext.getRegistry().lookupConnector("thirdConnector");
        Assert.assertNotNull((Object)c);
        FilenameParser parser = c.getFilenameParser();
        Assert.assertTrue((String)parser.getClass().getName(), (boolean)(c.getFilenameParser() instanceof ExpressionFilenameParser));
        Assert.assertTrue((boolean)c.isConnected());
        Assert.assertTrue((boolean)c.isStarted());
        Assert.assertFalse((boolean)c.isRecursive());
    }

    @Test
    public void testTransformersOnEndpoints() throws Exception {
        Object transformer1 = muleContext.getEndpointFactory().getInboundEndpoint("ep1").getTransformers().get(0);
        Assert.assertNotNull(transformer1);
        Assert.assertEquals(FileToByteArray.class, transformer1.getClass());
        Object transformer2 = muleContext.getEndpointFactory().getInboundEndpoint("ep2").getTransformers().get(0);
        Assert.assertNotNull(transformer2);
        Assert.assertEquals(FileToString.class, transformer2.getClass());
    }

    @Test
    public void testFileFilter() throws Exception {
        InboundEndpoint endpoint;
        Object service = muleContext.getRegistry().lookupObject("Test");
        Assert.assertNotNull((Object)service);
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW)) {
            endpoint = (InboundEndpoint)((Flow)service).getMessageSource();
        } else {
            List endpoints = ((ServiceCompositeMessageSource)((Service)service).getMessageSource()).getEndpoints();
            Assert.assertEquals((long)1L, (long)endpoints.size());
            endpoint = (InboundEndpoint)endpoints.get(0);
        }
        Filter filter = endpoint.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof FilenameRegexFilter));
        FilenameRegexFilter f = (FilenameRegexFilter)filter;
        Assert.assertEquals((Object)false, (Object)f.isCaseSensitive());
        Assert.assertEquals((Object)"(^SemDirector_Report-\\d)(.*)(tab$)", (Object)f.getPattern());
    }
}

