/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;

public abstract class AbstractFileFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    public static final String TEST_MESSAGE = "Test file contents";
    public static final String TARGET_FILE = "TARGET_FILE";
    protected File tmpDir;

    public AbstractFileFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "file-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "file-functional-test-flow.xml"});
    }

    protected String fileToUrl(File file) throws MalformedURLException {
        return file.getAbsoluteFile().toURI().toURL().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForFileSystem() throws Exception {
        AbstractFileFunctionalTestCase abstractFileFunctionalTestCase = this;
        synchronized (abstractFileFunctionalTestCase) {
            ((Object)((Object)this)).wait(1000L);
        }
    }

    protected File initForRequest() throws Exception {
        this.createTempDirectory();
        File target = this.createAndPopulateTempFile("mule-file-test-", ".txt");
        FileConnector connector = (FileConnector)muleContext.getRegistry().lookupConnector("receiveConnector");
        connector.setReadFromDirectory(this.tmpDir.getAbsolutePath());
        this.logger.debug((Object)("Directory is " + connector.getReadFromDirectory()));
        this.waitForFileSystem();
        return target;
    }

    private void createTempDirectory() throws Exception {
        this.tmpDir = File.createTempFile("mule-file-test-", "-dir");
        this.tmpDir.delete();
        this.tmpDir.mkdir();
    }

    protected File createAndPopulateTempFile(String prefix, String suffix) throws Exception {
        File target = File.createTempFile(prefix, suffix, this.tmpDir);
        this.logger.info((Object)("Created temporary file: " + target.getAbsolutePath()));
        FileWriter out = new FileWriter(target);
        out.write(TEST_MESSAGE);
        ((Writer)out).close();
        target.deleteOnExit();
        return target;
    }

    protected void checkReceivedMessage(MuleMessage message) throws Exception {
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getPayload());
        Assert.assertTrue((boolean)(message.getPayload() instanceof InputStream));
        InputStream fis = (InputStream)message.getPayload();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)fis, (OutputStream)byteOut);
        fis.close();
        String result = new String(byteOut.toByteArray());
        Assert.assertEquals((Object)TEST_MESSAGE, (Object)result);
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        FileUtils.deleteTree((File)this.tmpDir);
    }

    protected File createDataFile(File folder, String testMessage) throws Exception {
        return this.createDataFile(folder, testMessage, null);
    }

    protected File createDataFile(File folder, String testMessage, String encoding) throws Exception {
        File target = File.createTempFile("mule-file-test-", ".txt", folder);
        target.deleteOnExit();
        FileUtils.writeStringToFile((File)target, (String)testMessage, (String)encoding);
        return target;
    }

    protected File createFolder(String name) {
        File result = FileUtils.newFile((String)name);
        result.delete();
        result.mkdir();
        result.deleteOnExit();
        return result;
    }
}

