/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileMessageReceiver;
import org.mule.util.FileUtils;

public class FileConnectorTestCase
extends AbstractConnectorTestCase {
    private static final long POLLING_FREQUENCY = 1234L;
    private static final long POLLING_FREQUENCY_OVERRIDE = 4321L;
    private static final String VALID_MESSAGE = "validMessage";
    private File validMessage;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        File tempDir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)"tmp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        this.validMessage = File.createTempFile("simple", ".mule", tempDir);
        Assert.assertNotNull((Object)this.validMessage);
        FileUtils.writeStringToFile((File)this.validMessage, (String)VALID_MESSAGE);
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteTree((File)FileUtils.newFile((String)FileConnectorTestCase.getTestConnector().getProtocol()));
        super.doTearDown();
    }

    public Connector createConnector() throws Exception {
        FileConnector connector = new FileConnector(muleContext);
        connector.setName("testFile");
        connector.setOutputAppend(true);
        return connector;
    }

    public String getTestEndpointURI() {
        return "file://" + muleContext.getConfiguration().getWorkingDirectory();
    }

    public Object getValidMessage() throws Exception {
        return this.validMessage;
    }

    @Test
    public void testConnectorPollingFrequency() throws Exception {
        FileConnector connector = (FileConnector)this.getConnector();
        connector.setPollingFrequency(1234L);
        InboundEndpoint endpoint = FileConnectorTestCase.getTestInboundEndpoint((String)"simple");
        Service service = FileConnectorTestCase.getTestService();
        MessageReceiver receiver = connector.createReceiver((FlowConstruct)service, endpoint);
        Assert.assertEquals((String)"Connector's polling frequency must not be ignored.", (long)1234L, (long)((FileMessageReceiver)receiver).getFrequency());
    }

    @Test
    public void testPollingFrequencyEndpointOverride() throws Exception {
        FileConnector connector = (FileConnector)this.getConnector();
        connector.setPollingFrequency(-1L);
        InboundEndpoint endpoint = FileConnectorTestCase.getTestInboundEndpoint((String)"simple");
        endpoint.getProperties().put("pollingFrequency", String.valueOf(4321L));
        Service service = FileConnectorTestCase.getTestService();
        MessageReceiver receiver = connector.createReceiver((FlowConstruct)service, endpoint);
        Assert.assertEquals((String)"Polling frequency endpoint override must not be ignored.", (long)4321L, (long)((FileMessageReceiver)receiver).getFrequency());
    }

    @Test
    public void testOutputAppendEndpointOverride() throws Exception {
        FileConnector connector = (FileConnector)this.getConnector();
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(new URIBuilder("file://foo", muleContext));
        OutboundEndpoint endpoint = endpointBuilder.buildOutboundEndpoint();
        endpoint.getProperties().put("outputAppend", "true");
        try {
            connector.getDispatcherFactory().create(endpoint);
            Assert.fail((String)"outputAppend cannot be configured on File endpoints");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testOnlySingleDispatcherPerEndpoint() throws InitialisationException {
        FileConnector connector = (FileConnector)this.getConnector();
        Assert.assertEquals((long)1L, (long)connector.getMaxDispatchersActive());
        connector.setMaxDispatchersActive(2);
        Assert.assertEquals((long)1L, (long)connector.getMaxDispatchersActive());
    }

    @Test
    public void testConnectorMessageFactoryNonStreaming() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        ((FileConnector)connector).setStreaming(false);
        Object payload = this.getValidMessage();
        MuleMessage message = connector.createMuleMessageFactory().create(payload, this.encoding);
        Assert.assertNotNull((Object)message);
        byte[] messagePayload = (byte[])message.getPayload();
        Assert.assertTrue((boolean)Arrays.equals(VALID_MESSAGE.getBytes(), messagePayload));
    }
}

