/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileMessageRequester;

public class FileMessageRequesterTestCase
extends AbstractMuleContextTestCase {
    private static final String CONNECTOR_MOVE_DIR = "connector/moveto";
    private static final String ENDPOINT_MOVE_DIR = "endpoint/moveto";
    private static final String CONNECTOR_MOVE_TO_PATTERN = "#connector";
    private static final String ENDPOINT_MOVE_TO_PATTERN = "#endpoint";
    private FileConnector connector;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.connector = new FileConnector(muleContext);
        this.connector.setMoveToDirectory(CONNECTOR_MOVE_DIR);
        this.connector.setMoveToPattern(CONNECTOR_MOVE_TO_PATTERN);
    }

    @Test
    public void testMoveDirectoryFromConnector() throws Exception {
        FileMessageRequester requester = new FileMessageRequester(this.createEndpoint());
        Assert.assertEquals((Object)CONNECTOR_MOVE_DIR, (Object)requester.getMoveDirectory());
    }

    @Test
    public void testMoveDirectoryFromEndpoint() throws Exception {
        InboundEndpoint endpoint = this.createEndpoint("moveToDirectory", ENDPOINT_MOVE_DIR);
        FileMessageRequester requester = new FileMessageRequester(endpoint);
        Assert.assertEquals((Object)ENDPOINT_MOVE_DIR, (Object)requester.getMoveDirectory());
    }

    @Test
    public void testMoveToPatternFromConnector() throws Exception {
        FileMessageRequester requester = new FileMessageRequester(this.createEndpoint());
        Assert.assertEquals((Object)CONNECTOR_MOVE_TO_PATTERN, (Object)requester.getMoveToPattern());
    }

    @Test
    public void testMoveToPatternFromEndpoint() throws Exception {
        InboundEndpoint endpoint = this.createEndpoint("moveToPattern", ENDPOINT_MOVE_TO_PATTERN);
        FileMessageRequester requester = new FileMessageRequester(endpoint);
        Assert.assertEquals((Object)ENDPOINT_MOVE_TO_PATTERN, (Object)requester.getMoveToPattern());
    }

    private InboundEndpoint createEndpoint() {
        return this.createEndpoint(null, null);
    }

    private InboundEndpoint createEndpoint(Object key, Object value) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        if (key != null) {
            properties.put(key, value);
        }
        return new DefaultInboundEndpoint((Connector)this.connector, null, null, properties, null, false, MessageExchangePattern.ONE_WAY, 42, null, null, null, muleContext, null, null, null, null, null, false, null);
    }
}

