/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.simple.ByteArrayToSerializable;
import org.mule.transformer.simple.SerializableToByteArray;
import org.mule.transport.AbstractConnector;
import org.mule.transport.file.ExpressionFilenameParser;
import org.mule.transport.file.FileMuleMessageFactory;
import org.mule.transport.file.FilenameParser;
import org.mule.transport.file.filters.FilenameWildcardFilter;
import org.mule.util.FileUtils;

public class FileConnector
extends AbstractConnector {
    private static Log logger = LogFactory.getLog(FileConnector.class);
    public static final String FILE = "file";
    private static final String DEFAULT_WORK_FILENAME_PATTERN = "#[function:uuid].#[function:systime].#[header:originalFilename]";
    public static final String PROPERTY_FILE_AGE = "fileAge";
    public static final String PROPERTY_MOVE_TO_PATTERN = "moveToPattern";
    public static final String PROPERTY_MOVE_TO_DIRECTORY = "moveToDirectory";
    public static final String PROPERTY_READ_FROM_DIRECTORY = "readFromDirectoryName";
    public static final String PROPERTY_OUTPUT_PATTERN = "outputPattern";
    public static final String PROPERTY_FILENAME = "filename";
    public static final String PROPERTY_ORIGINAL_FILENAME = "originalFilename";
    public static final String PROPERTY_DIRECTORY = "directory";
    public static final String PROPERTY_WRITE_TO_DIRECTORY = "writeToDirectoryName";
    public static final String PROPERTY_FILE_SIZE = "fileSize";
    public static final String PROPERTY_FILE_TIMESTAMP = "timestamp";
    public static final long DEFAULT_POLLING_FREQUENCY = 1000L;
    private long pollingFrequency = 0L;
    private String moveToPattern = null;
    private String writeToDirectoryName = null;
    private String moveToDirectoryName = null;
    private String workDirectoryName = null;
    private String workFileNamePattern = "#[function:uuid].#[function:systime].#[header:originalFilename]";
    private String readFromDirectoryName = null;
    private String outputPattern = null;
    private boolean outputAppend = false;
    private boolean autoDelete = true;
    private boolean checkFileAge = false;
    private long fileAge = 0L;
    private FileOutputStream outputStream = null;
    private boolean serialiseObjects = false;
    private boolean streaming = true;
    public FilenameParser filenameParser = new ExpressionFilenameParser();
    private boolean recursive = false;

    public FileConnector(MuleContext context) {
        super(context);
    }

    protected void configureDispatcherPool() {
        if (this.isOutputAppend()) {
            this.setMaxDispatchersActive(this.getDispatcherThreadingProfile().getMaxThreadsActive());
        } else {
            super.configureDispatcherPool();
        }
    }

    public void setMaxDispatchersActive(int value) {
        if (this.isOutputAppend() && value != 1) {
            logger.warn((Object)"MULE-1773: cannot configure maxDispatchersActive when using outputAppend. New value not set");
        } else {
            super.setMaxDispatchersActive(value);
        }
    }

    protected Object getReceiverKey(FlowConstruct flowConstruct, InboundEndpoint endpoint) {
        if (endpoint.getFilter() != null && endpoint.getFilter() instanceof FilenameWildcardFilter) {
            return endpoint.getEndpointURI().getAddress() + "/" + ((FilenameWildcardFilter)endpoint.getFilter()).getPattern();
        }
        return endpoint.getEndpointURI().getAddress();
    }

    public MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        String readDir = endpoint.getEndpointURI().getAddress();
        if (null != this.getReadFromDirectory()) {
            readDir = this.getReadFromDirectory();
        }
        long polling = this.pollingFrequency;
        String moveTo = this.moveToDirectoryName;
        String moveToPattern = this.getMoveToPattern();
        Map props = endpoint.getProperties();
        if (props != null) {
            String tempFileAge;
            String tempPolling;
            String tempMoveToPattern;
            String move;
            String read = (String)props.get(PROPERTY_READ_FROM_DIRECTORY);
            if (read != null) {
                readDir = read;
            }
            if ((move = (String)props.get(PROPERTY_MOVE_TO_DIRECTORY)) != null) {
                moveTo = move;
            }
            if ((tempMoveToPattern = (String)props.get(PROPERTY_MOVE_TO_PATTERN)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("set moveTo Pattern to: " + tempMoveToPattern));
                }
                moveToPattern = tempMoveToPattern;
            }
            if ((tempPolling = (String)props.get("pollingFrequency")) != null) {
                polling = Long.parseLong(tempPolling);
            }
            if (polling <= 0L) {
                polling = 1000L;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set polling frequency to: " + polling));
            }
            if ((tempFileAge = (String)props.get(PROPERTY_FILE_AGE)) != null) {
                try {
                    this.setFileAge(Long.parseLong(tempFileAge));
                }
                catch (Exception ex1) {
                    logger.error((Object)"Failed to set fileAge", (Throwable)ex1);
                }
            }
        }
        try {
            return this.serviceDescriptor.createMessageReceiver((Connector)this, flowConstruct, endpoint, new Object[]{readDir, moveTo, moveToPattern, new Long(polling)});
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreateObjectWith((String)"Message Receiver", (Object)this.serviceDescriptor), (Throwable)e, (Initialisable)this);
        }
    }

    public String getProtocol() {
        return FILE;
    }

    public FilenameParser getFilenameParser() {
        return this.filenameParser;
    }

    public void setFilenameParser(FilenameParser filenameParser) {
        this.filenameParser = filenameParser;
        if (filenameParser != null) {
            filenameParser.setMuleContext(this.muleContext);
        }
    }

    protected void doDispose() {
        try {
            this.doStop();
        }
        catch (MuleException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void doInitialise() throws InitialisationException {
        if (this.filenameParser != null) {
            this.filenameParser.setMuleContext(this.muleContext);
        }
        if (this.isOutputAppend()) {
            super.setMaxDispatchersActive(1);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to close file output stream on stop: " + e));
            }
        }
    }

    public String getMoveToDirectory() {
        return this.moveToDirectoryName;
    }

    public void setMoveToDirectory(String dir) {
        this.moveToDirectoryName = dir;
    }

    public void setWorkDirectory(String workDirectoryName) throws IOException {
        File workDirectory;
        this.workDirectoryName = workDirectoryName;
        if (workDirectoryName != null && !(workDirectory = FileUtils.openDirectory((String)workDirectoryName)).canWrite()) {
            throw new IOException("Error on initialization, Work Directory '" + workDirectory + "' is not writeable");
        }
    }

    public String getWorkDirectory() {
        return this.workDirectoryName;
    }

    public void setWorkFileNamePattern(String workFileNamePattern) {
        this.workFileNamePattern = workFileNamePattern;
    }

    public String getWorkFileNamePattern() {
        return this.workFileNamePattern;
    }

    public boolean isOutputAppend() {
        return this.outputAppend;
    }

    public void setOutputAppend(boolean outputAppend) {
        this.outputAppend = outputAppend;
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public FileOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(FileOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    public long getFileAge() {
        return this.fileAge;
    }

    public boolean getCheckFileAge() {
        return this.checkFileAge;
    }

    public void setFileAge(long fileAge) {
        this.fileAge = fileAge;
        this.checkFileAge = true;
    }

    public String getWriteToDirectory() {
        return this.writeToDirectoryName;
    }

    public void setWriteToDirectory(String dir) throws IOException {
        File writeToDirectory;
        this.writeToDirectoryName = dir;
        if (this.writeToDirectoryName != null && !(writeToDirectory = FileUtils.openDirectory((String)this.writeToDirectoryName)).canWrite()) {
            throw new IOException("Error on initialization, " + writeToDirectory + " does not exist or is not writeable");
        }
    }

    public String getReadFromDirectory() {
        return this.readFromDirectoryName;
    }

    public void setReadFromDirectory(String dir) throws IOException {
        this.readFromDirectoryName = dir;
        if (this.readFromDirectoryName != null) {
            FileUtils.openDirectory((String)this.readFromDirectoryName);
        }
    }

    public boolean isSerialiseObjects() {
        return this.serialiseObjects;
    }

    public void setSerialiseObjects(boolean serialiseObjects) {
        if (serialiseObjects) {
            if (this.serviceOverrides == null) {
                this.serviceOverrides = new Properties();
            }
            this.serviceOverrides.setProperty("inbound.transformer", ByteArrayToSerializable.class.getName());
            this.serviceOverrides.setProperty("outbound.transformer", SerializableToByteArray.class.getName());
        }
        this.serialiseObjects = serialiseObjects;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public String getMoveToPattern() {
        return this.moveToPattern;
    }

    public void setMoveToPattern(String moveToPattern) {
        this.moveToPattern = moveToPattern;
    }

    public OutputStream getOutputStream(OutboundEndpoint endpoint, MuleEvent event) throws MuleException {
        String outPattern;
        MuleMessage message = event.getMessage();
        String address = endpoint.getEndpointURI().getAddress();
        String writeToDirectory = (String)message.getOutboundProperty(PROPERTY_WRITE_TO_DIRECTORY);
        if (writeToDirectory == null) {
            writeToDirectory = this.getWriteToDirectory();
        }
        if (writeToDirectory != null) {
            address = this.getFilenameParser().getFilename(message, writeToDirectory);
        }
        if ((outPattern = (String)endpoint.getProperty((Object)PROPERTY_OUTPUT_PATTERN)) == null) {
            outPattern = (String)message.getOutboundProperty(PROPERTY_OUTPUT_PATTERN);
        }
        if (outPattern == null) {
            outPattern = this.getOutputPattern();
        }
        try {
            String filename;
            if (outPattern != null) {
                filename = this.generateFilename(message, outPattern);
            } else {
                filename = (String)message.getOutboundProperty(PROPERTY_FILENAME);
                if (filename == null) {
                    filename = this.generateFilename(message, null);
                }
            }
            if (filename == null) {
                throw new IOException("Filename is null");
            }
            File file = FileUtils.createFile((String)(address + "/" + filename));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Writing file to: " + file.getAbsolutePath()));
            }
            return new FileOutputStream(file, this.isOutputAppend());
        }
        catch (IOException e) {
            throw new DispatchException(CoreMessages.streamingFailedNoStream(), event, (MessageProcessor)endpoint, (Throwable)e);
        }
    }

    private String generateFilename(MuleMessage message, String pattern) {
        if (pattern == null) {
            pattern = this.getOutputPattern();
        }
        return this.getFilenameParser().getFilename(message, pattern);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public MuleMessageFactory createMuleMessageFactory() throws CreateException {
        if (this.isStreaming()) {
            return new FileMuleMessageFactory(this.muleContext);
        }
        return super.createMuleMessageFactory();
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }
}

