/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.file.ReceiverFileInputStream;

public class FileMuleMessageFactory
extends AbstractMuleMessageFactory {
    public FileMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{File.class, ReceiverFileInputStream.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        File file = this.convertToFile(transportMessage);
        this.setPropertiesFromFile((MuleMessage)message, file);
    }

    protected File convertToFile(Object transportMessage) {
        File file = null;
        if (transportMessage instanceof File) {
            file = (File)transportMessage;
        } else if (transportMessage instanceof ReceiverFileInputStream) {
            file = ((ReceiverFileInputStream)transportMessage).getCurrentFile();
        }
        return file;
    }

    protected void setPropertiesFromFile(MuleMessage message, File file) {
        message.setOutboundProperty("originalFilename", (Object)file.getName());
        message.setOutboundProperty("directory", (Object)file.getParent());
        message.setOutboundProperty("fileSize", (Object)file.length());
    }
}

