/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import org.junit.Assert;
import org.mule.api.transport.Connector;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.file.AbstractFileFunctionalTestCase;
import org.mule.transport.file.FileConnector;

public abstract class AbstractFileMoveDeleteTestCase
extends AbstractFileFunctionalTestCase {
    public AbstractFileMoveDeleteTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected File configureConnector(File inFile, boolean stream, boolean move, boolean delete, Class<? extends AbstractMuleMessageFactory> messageFactoryClass) throws Exception {
        return this.configureConnector(inFile, stream, move, delete, false, messageFactoryClass);
    }

    protected File configureConnector(File inFile, boolean stream, boolean move, boolean delete, boolean useWorkDir, Class<? extends AbstractMuleMessageFactory> messageFactoryClass) throws Exception {
        FileConnector fc = new FileConnector(muleContext);
        fc.setPollingFrequency(3000000L);
        if (messageFactoryClass != null) {
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("message.factory", messageFactoryClass.getName());
            fc.setServiceOverrides(overrides);
        }
        fc.setName("moveDeleteConnector");
        File moveToDir = new File(inFile.getParent() + "/moveto/");
        moveToDir.mkdir();
        File workDir = new File(inFile.getParent() + "/work/");
        workDir.mkdir();
        muleContext.getRegistry().registerConnector((Connector)fc);
        if (move) {
            fc.setMoveToDirectory(moveToDir.getPath());
        }
        if (useWorkDir) {
            fc.setWorkDirectory(workDir.getPath());
        }
        fc.setAutoDelete(delete);
        fc.setStreaming(stream);
        return moveToDir;
    }

    protected void assertFiles(File inFile, File moveToDir, boolean move, boolean delete) throws Exception {
        File movedFile;
        this.waitForFileSystem();
        boolean inFileShouldExst = !delete && !move;
        Assert.assertTrue((inFile.exists() == inFileShouldExst ? 1 : 0) != 0);
        if (inFileShouldExst) {
            Assert.assertEquals((Object)"Test file contents", (Object)new BufferedReader(new FileReader(inFile)).readLine());
        }
        Assert.assertTrue(((movedFile = new File(moveToDir.getPath() + "/" + inFile.getName())).exists() == move ? 1 : 0) != 0);
        if (move) {
            Assert.assertEquals((Object)"Test file contents", (Object)new BufferedReader(new FileReader(movedFile)).readLine());
        }
    }

    protected void assertFilesUntouched(File inFile) {
        Assert.assertTrue((boolean)inFile.exists());
        File movedFile = new File(inFile.getParent() + "/moveto/" + inFile.getName());
        Assert.assertFalse((boolean)movedFile.exists());
    }
}

