/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.transport.file.FileConnector;
import org.mule.util.FileUtils;

public class AutoDeleteOnFileDispatcherReceiverTestCase
extends AbstractMuleContextTestCase {
    private File validMessage;
    private String tempDirName = "input";
    File tempDir;
    Connector connector;

    @Test
    public void testAutoDeleteFalseOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(false);
        MuleEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((MuleEvent)event);
        MuleMessage message = RequestContext.getEventContext().requestEvent(this.getTestEndpointURI() + "/" + this.tempDirName + "?connector=FileConnector", 50000L);
        Assert.assertNotNull((Object)message.getPayloadAsString());
        File[] files = this.tempDir.listFiles();
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < files.length; ++i) {
            Assert.assertTrue((boolean)files[i].getName().equals(message.getOutboundProperty("originalFilename")));
            files[i].delete();
        }
    }

    @Test
    public void testAutoDeleteTrueOnDispatcher() throws Exception {
        ((FileConnector)this.connector).setAutoDelete(true);
        MuleEvent event = AutoDeleteOnFileDispatcherReceiverTestCase.getTestEvent((Object)"TestData");
        event = RequestContext.setEvent((MuleEvent)event);
        MuleMessage message = RequestContext.getEventContext().requestEvent(this.getTestEndpointURI() + "/" + this.tempDirName, 50000L);
        Assert.assertNotNull((Object)message.getPayload());
        Assert.assertTrue((boolean)(message.getPayload() instanceof InputStream));
        Assert.assertTrue((this.tempDir.listFiles().length > 0 ? 1 : 0) != 0);
        ((InputStream)message.getPayload()).close();
        PollingProber prober = new PollingProber(1000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return AutoDeleteOnFileDispatcherReceiverTestCase.this.tempDir.listFiles().length == 0;
            }

            public String describeFailure() {
                return "File was not deleted from temp directory";
            }
        });
        Assert.assertTrue((this.tempDir.listFiles().length == 0 ? 1 : 0) != 0);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tempDir = FileUtils.newFile((String)muleContext.getConfiguration().getWorkingDirectory(), (String)this.tempDirName);
        this.tempDir.deleteOnExit();
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
        this.validMessage = File.createTempFile("hello", ".txt", this.tempDir);
        Assert.assertNotNull((Object)this.validMessage);
        this.connector = this.getConnector();
        this.connector.start();
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteTree((File)FileUtils.newFile((String)AutoDeleteOnFileDispatcherReceiverTestCase.getTestConnector().getProtocol()));
        super.doTearDown();
    }

    public Connector getConnector() throws Exception {
        FileConnector connector = new FileConnector(muleContext);
        connector.setName("FileConnector");
        muleContext.getRegistry().registerConnector((Connector)connector);
        return connector;
    }

    public String getTestEndpointURI() {
        return "file://" + muleContext.getConfiguration().getWorkingDirectory();
    }
}

