/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.component.Component;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.object.ObjectFactory;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.component.DefaultJavaComponent;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.model.seda.SedaService;
import org.mule.object.SingletonObjectFactory;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.transformer.NoActionTransformer;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.file.AbstractFileMoveDeleteTestCase;
import org.mule.transport.file.FileMuleMessageFactory;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.util.concurrent.Latch;

public class FileReceiverMoveDeleteTestCase
extends AbstractFileMoveDeleteTestCase {
    public FileReceiverMoveDeleteTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.getRegistry().unregisterTransformer("_ObjectToByteArray");
    }

    @Test
    public void testMoveAndDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, true, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, true, true);
    }

    @Test
    public void testMoveAndDeleteWorkDirStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, true, true, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, true, true);
    }

    @Test
    public void testMoveOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, false, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, true, false);
    }

    @Test
    public void testMoveOnlyWorkDirStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, false, true, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, true, false);
    }

    @Test
    public void testDeleteOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, true, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, false, true);
    }

    @Test
    public void testNoMoveNoDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, false, null);
        this.assertRecevied(this.configureService(inFile, true, false));
        this.assertFiles(inFile, moveToDir, false, false);
    }

    @Test
    public void testMoveAndDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, true, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, true, true);
    }

    @Test
    public void testMoveOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, true, false);
    }

    @Test
    public void testDeleteOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, true, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, false, true);
    }

    @Test
    public void testNoMoveNoDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, false, null);
        this.assertRecevied(this.configureService(inFile, false, false));
        this.assertFiles(inFile, moveToDir, false, false);
    }

    @Test
    public void testMoveAndDeleteFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, FileMuleMessageFactory.class);
        this.assertRecevied(this.configureService(inFile, false, true));
        this.assertFiles(inFile, moveToDir, true, true);
    }

    @Test
    public void testMoveOnlyFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, FileMuleMessageFactory.class);
        this.assertRecevied(this.configureService(inFile, false, true));
        this.assertFiles(inFile, moveToDir, true, false);
    }

    @Test
    public void testDeleteOnlyFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, true, FileMuleMessageFactory.class);
        this.assertRecevied(this.configureService(inFile, false, true));
        this.assertFiles(inFile, moveToDir, false, true);
    }

    @Test
    public void testNoMoveNoDeleteFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, false, FileMuleMessageFactory.class);
        this.assertRecevied(this.configureService(inFile, false, true));
        this.assertFiles(inFile, moveToDir, false, false);
    }

    protected Latch configureService(File inFile, boolean streaming, boolean filePayload) throws Exception {
        SedaService service = new SedaService(muleContext);
        service.setName("moveDeleteBridgeService");
        String url = this.fileToUrl(inFile.getParentFile()) + "?connector=moveDeleteConnector";
        FileMessageFactoryAssertingTransformer transformer = null;
        if (streaming) {
            if (filePayload) {
                Assert.fail((String)"Inconsistant test case: streaming and file payload are not compatible");
            } else {
                transformer = new FileMessageFactoryAssertingTransformer(ReceiverFileInputStream.class);
            }
        } else {
            transformer = filePayload ? new FileMessageFactoryAssertingTransformer(File.class) : new FileMessageFactoryAssertingTransformer(byte[].class);
        }
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(url, muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)transformer);
        if (filePayload) {
            endpointBuilder.addMessageProcessor((MessageProcessor)new NoActionTransformer());
        }
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)endpointBuilder);
        ((CompositeMessageSource)service.getMessageSource()).addSource((MessageSource)endpoint);
        final Latch latch = new Latch();
        FunctionalTestComponent testComponent = new FunctionalTestComponent();
        testComponent.setMuleContext(muleContext);
        testComponent.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object message) throws Exception {
                Assert.assertEquals((long)1L, (long)latch.getCount());
                Assert.assertEquals((Object)"Test file contents", (Object)context.transformMessageToString());
                latch.countDown();
            }
        });
        testComponent.initialise();
        DefaultJavaComponent component = new DefaultJavaComponent((ObjectFactory)new SingletonObjectFactory((Object)testComponent));
        component.setMuleContext(muleContext);
        service.setComponent((Component)component);
        service.setModel(muleContext.getRegistry().lookupSystemModel());
        muleContext.getRegistry().registerService((Service)service);
        return latch;
    }

    protected void assertRecevied(Latch latch) throws Exception {
        Assert.assertNotNull((Object)latch);
        Assert.assertTrue((boolean)latch.await(2000L, TimeUnit.MILLISECONDS));
    }

    private class FileMessageFactoryAssertingTransformer
    extends AbstractMessageTransformer {
        private Class<?> expectedPayload;

        public FileMessageFactoryAssertingTransformer(Class<?> expectedPayload) {
            this.expectedPayload = expectedPayload;
        }

        public Object transformMessage(MuleMessage message, String outputEncoding) {
            Assert.assertEquals(this.expectedPayload, message.getPayload().getClass());
            if (this.expectedPayload.equals(ReceiverFileInputStream.class)) {
                File file = ((ReceiverFileInputStream)message.getPayload()).getCurrentFile();
                FileReceiverMoveDeleteTestCase.this.assertFilesUntouched(file);
            }
            return message;
        }
    }
}

