/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.reliability;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.file.AbstractFileMoveDeleteTestCase;

public class InboundMessageLossTestCase
extends AbstractFileMoveDeleteTestCase {
    protected Prober prober = new PollingProber(10000L, 100L);

    public InboundMessageLossTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected String getConfigResources() {
        return "reliability/inbound-message-loss.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((DefaultSystemExceptionStrategy)muleContext.getExceptionListener()).setRollbackTxFilter(new WildcardFilter("*"));
    }

    @Test
    public void testNoException() throws Exception {
        this.tmpDir = this.createFolder(".mule/noException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testTransformerException() throws Exception {
        this.tmpDir = this.createFolder(".mule/transformerException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return file.exists();
            }

            public String describeFailure() {
                return "File should have been restored";
            }
        });
    }

    @Test
    public void testRouterException() throws Exception {
        this.tmpDir = this.createFolder(".mule/routerException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return file.exists();
            }

            public String describeFailure() {
                return "File should have been restored";
            }
        });
    }

    @Test
    public void testComponentException() throws Exception {
        this.tmpDir = this.createFolder(".mule/componentException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testCatchExceptionStrategyConsumesMessage() throws Exception {
        this.tmpDir = this.createFolder(".mule/exceptionHandled");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testDefaultExceptionStrategyConsumesMessage() throws Exception {
        this.tmpDir = this.createFolder(".mule/commitOnException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testRollbackExceptionStrategyConsumesMessage() throws Exception {
        final CountDownLatch exceptionStrategyLatch = new CountDownLatch(4);
        this.tmpDir = this.createFolder(".mule/rollbackOnException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                exceptionStrategyLatch.countDown();
            }
        });
        if (!exceptionStrategyLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should be redelivered");
        }
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }
}

