/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.file.AbstractFileMuleMessageFactoryTestCase;
import org.mule.transport.file.FileMuleMessageFactory;
import org.mule.transport.file.ReceiverFileInputStream;

public class FileMuleMessageFactoryTestCase
extends AbstractFileMuleMessageFactoryTestCase {
    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new FileMuleMessageFactory(muleContext);
    }

    @Override
    protected Object getValidTransportMessage() {
        return this.tempFile;
    }

    @Test
    public void testMessageProperties() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create(this.getValidTransportMessage(), this.encoding);
        Assert.assertNotNull((Object)message);
        this.assertMessageProperties(message);
    }

    @Test
    public void testCreateMessageFromStream() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        ReceiverFileInputStream stream = new ReceiverFileInputStream(this.tempFile, false, null);
        MuleMessage message = factory.create((Object)stream, this.encoding);
        Assert.assertNotNull((Object)message);
        this.assertMessageProperties(message);
    }

    private void assertMessageProperties(MuleMessage message) {
        Assert.assertEquals((Object)this.tempFile.getName(), (Object)message.getOutboundProperty("originalFilename"));
        Assert.assertEquals((Object)this.tempFile.getParent(), (Object)message.getOutboundProperty("directory"));
        Assert.assertEquals((Object)0L, (Object)message.getOutboundProperty("fileSize"));
    }
}

