/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.model.streaming.DelegatingInputStream;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.file.AbstractFileMoveDeleteTestCase;
import org.mule.transport.file.FileMuleMessageFactory;
import org.mule.util.IOUtils;

public class FileRequestorMoveDeleteTestCase
extends AbstractFileMoveDeleteTestCase {
    public FileRequestorMoveDeleteTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testMoveAndDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, true, null);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, true, true);
    }

    @Test
    public void testMoveOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, true, false, null);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, true, false);
    }

    @Test
    public void testDeleteOnlyStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, true, null);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, false, true);
    }

    @Test
    public void testNoMoveNoDeleteStreaming() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, true, false, false, null);
        this.assertRequested(this.request(inFile), inFile, true);
        this.assertFiles(inFile, moveToDir, false, false);
    }

    @Test
    public void testMoveAndDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, true, null);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, true, true);
    }

    @Test
    public void testMoveOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, null);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, true, false);
    }

    @Test
    public void testDeleteOnly() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, true, null);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, false, true);
    }

    @Test
    public void testNoMoveNoDelete() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, false, null);
        this.assertRequested(this.request(inFile), inFile, false);
        this.assertFiles(inFile, moveToDir, false, false);
    }

    @Test
    public void testMoveAndDeleteFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, FileMuleMessageFactory.class);
    }

    @Test
    public void testMoveOnlyFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, true, false, FileMuleMessageFactory.class);
    }

    @Test
    public void testDeleteOnlyFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, true, FileMuleMessageFactory.class);
    }

    @Test
    public void testNoMoveNoDeleteFilePayload() throws Exception {
        File inFile = this.initForRequest();
        File moveToDir = this.configureConnector(inFile, false, false, false, FileMuleMessageFactory.class);
        this.assertFiles(inFile, moveToDir, false, false);
    }

    protected void assertRequested(MuleMessage message, File inFile, boolean streaming) throws IOException, MessagingException, InterruptedException {
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)inFile.getName(), (Object)message.getOutboundProperty("originalFilename"));
        Assert.assertNotNull((Object)message.getPayload());
        if (streaming) {
            Assert.assertTrue((boolean)(message.getPayload() instanceof DelegatingInputStream));
            InputStream fis = (InputStream)message.getPayload();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)fis, (OutputStream)byteOut);
            this.assertFilesUntouched(inFile);
            fis.close();
            String result = new String(byteOut.toByteArray());
            Assert.assertEquals((Object)"Test file contents", (Object)result);
        } else {
            Assert.assertTrue((boolean)(message.getPayload() instanceof byte[]));
            Assert.assertEquals((Object)"Test file contents", (Object)new String((byte[])message.getPayload()));
        }
    }

    protected MuleMessage request(File file) throws MuleException, MalformedURLException {
        MuleClient muleClient = new MuleClient(muleContext);
        return muleClient.request(this.fileToUrl(file) + "?connector=moveDeleteConnector", 2000L);
    }
}

