/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.message.processing.MessageProcessingManager;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileMessageReceiver;
import org.mule.transport.file.FileMuleMessageFactory;
import org.mule.util.UUID;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class FileMessageReceiverMessageProcessingTestCase
extends AbstractMuleTestCase {
    public static final String IMPUT_FILES_DIR = "temp";
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FileConnector mockFileConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowConstruct mockFlowConstruct;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InboundEndpoint mockInboundEndpoint;
    private FileMuleMessageFactory mockMessageFactory;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleMessage mockMessage;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessor mockMessageProcessor;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingExceptionHandler mockMessagingExceptionHandler;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockHandledMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockUnhandledMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessingManager mockMessageManager;

    @Test
    public void testProcessFileAndDeleteIt() throws Exception {
        this.configureMocks();
        this.configureAutoDelete();
        this.configureWorkingDirectory(null);
        FileMessageReceiver fileMessageReceiver = this.createFileMessageReceiver();
        File file = this.createMockFile("text.csv");
        fileMessageReceiver.processFile(file);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testProcessFileThatFailsThrowHandleExceptionThenDeleteIt() throws Exception {
        this.configureMocks();
        this.configureAutoDelete();
        this.configureWorkingDirectory(null);
        this.configureListenerToThrow(this.mockHandledMessagingException);
        FileMessageReceiver fileMessageReceiver = this.createFileMessageReceiver();
        File file = this.createMockFile("text.csv");
        fileMessageReceiver.processFile(file);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testProcessFileThatFailsThrowsUnhandledExceptionThenDoNotDeleteIt() throws Exception {
        this.configureMocks();
        this.configureAutoDelete();
        this.configureWorkingDirectory(null);
        this.configureListenerToThrow(this.mockUnhandledMessagingException);
        FileMessageReceiver fileMessageReceiver = this.createFileMessageReceiver();
        File file = this.createMockFile("text.csv");
        fileMessageReceiver.processFile(file);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testProcessStreamingFileTheDoNotDeleteIt() throws Exception {
        this.configureMocks();
        this.configureAutoDelete();
        this.configureStreaming();
        this.configureWorkingDirectory(null);
        FileMessageReceiver fileMessageReceiver = this.createFileMessageReceiver();
        File file = this.createMockFile("text.csv");
        fileMessageReceiver.processFile(file);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testProcessStreamingFileThatFailsThrowHandleExceptionThenDoNotDeleteIt() throws Exception {
        this.configureMocks();
        this.configureAutoDelete();
        this.configureStreaming();
        this.configureWorkingDirectory(null);
        this.configureListenerToThrow(this.mockHandledMessagingException);
        FileMessageReceiver fileMessageReceiver = this.createFileMessageReceiver();
        File file = this.createMockFile("text.csv");
        fileMessageReceiver.processFile(file);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testProcessStreamingFileThatFailsThrowsUnhandledExceptionThenDoNotDeleteIt() throws Exception {
        this.configureMocks();
        this.configureAutoDelete();
        this.configureStreaming();
        this.configureWorkingDirectory(null);
        this.configureListenerToThrow(this.mockUnhandledMessagingException);
        FileMessageReceiver fileMessageReceiver = this.createFileMessageReceiver();
        File file = this.createMockFile("text.csv");
        fileMessageReceiver.processFile(file);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
    }

    private void configureListenerToThrow(MessagingException mockMessagingException) throws Exception {
        Mockito.when((Object)this.mockMessageProcessor.process((MuleEvent)Mockito.any(MuleEvent.class))).thenThrow(new Throwable[]{mockMessagingException});
    }

    private void configureStreaming() {
        Mockito.when((Object)this.mockFileConnector.isStreaming()).thenReturn((Object)true);
    }

    private FileMessageReceiver createFileMessageReceiver() throws CreateException, InitialisationException {
        FileMessageReceiver fileMessageReceiver = new FileMessageReceiver((Connector)this.mockFileConnector, this.mockFlowConstruct, this.mockInboundEndpoint, IMPUT_FILES_DIR, null, null, 100L){

            protected boolean attemptFileLock(File sourceFile) throws MuleException {
                return true;
            }

            protected void initializeMessageFactory() throws InitialisationException {
                this.muleMessageFactory = FileMessageReceiverMessageProcessingTestCase.this.mockMessageFactory;
            }
        };
        fileMessageReceiver.setListener(this.mockMessageProcessor);
        fileMessageReceiver.initialise();
        return fileMessageReceiver;
    }

    private void configureMocks() throws CreateException {
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockFileConnector);
        Mockito.when((Object)this.mockInboundEndpoint.getFilter()).thenReturn(null);
        Mockito.when((Object)this.mockFileConnector.createMuleMessageFactory()).thenReturn((Object)this.mockMessageFactory);
        this.mockMessageFactory = new FileMuleMessageFactory(this.mockMuleContext){

            public MuleMessage create(Object transportMessage, String encoding) throws Exception {
                Mockito.when((Object)FileMessageReceiverMessageProcessingTestCase.this.mockMessage.getPayload()).thenReturn(transportMessage);
                return FileMessageReceiverMessageProcessingTestCase.this.mockMessage;
            }
        };
        Mockito.when((Object)this.mockMessage.getProperty("MULE_FORCE_SYNC", PropertyScope.INBOUND, (Object)Boolean.FALSE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockMessage.getInboundProperty("MULE_ROOT_MESSAGE_ID")).thenReturn((Object)UUID.getUUID());
        Mockito.when((Object)this.mockHandledMessagingException.getEvent()).thenReturn((Object)this.mockMuleEvent);
        Mockito.when((Object)this.mockUnhandledMessagingException.getEvent()).thenReturn((Object)this.mockMuleEvent);
        Mockito.when((Object)this.mockMuleEvent.getFlowConstruct().getExceptionListener()).thenReturn((Object)this.mockMessagingExceptionHandler);
        Mockito.when((Object)this.mockHandledMessagingException.causedRollback()).thenReturn((Object)false);
        Mockito.when((Object)this.mockUnhandledMessagingException.causedRollback()).thenReturn((Object)true);
        Mockito.when((Object)this.mockMessagingExceptionHandler.handleException((Exception)Mockito.any(Exception.class), (MuleEvent)Mockito.any(MuleEvent.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (invocationOnMock.getArguments()[0] == FileMessageReceiverMessageProcessingTestCase.this.mockHandledMessagingException) {
                    return FileMessageReceiverMessageProcessingTestCase.this.mockMuleEvent;
                }
                throw (Throwable)invocationOnMock.getArguments()[0];
            }
        });
        Mockito.when((Object)this.mockFileConnector.getMuleContext().getRegistry().get("_muleMessageProcessingManager")).thenReturn((Object)this.mockMessageManager);
    }

    private void configureWorkingDirectory(String workingDirectory) {
        Mockito.when((Object)this.mockFileConnector.getWorkDirectory()).thenReturn((Object)workingDirectory);
    }

    private void configureAutoDelete() {
        Mockito.when((Object)this.mockFileConnector.isAutoDelete()).thenReturn((Object)true);
    }

    private File createMockFile(String fileName) throws Exception {
        File file = File.createTempFile(fileName, ".txt");
        file.deleteOnExit();
        return file;
    }
}

