/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class FileEndpointTestCase
extends AbstractMuleContextTestCase {
    private EndpointURI newMuleEndpointURI(String text) throws Exception {
        MuleEndpointURI uri = new MuleEndpointURI(text, muleContext);
        uri.initialise();
        return uri;
    }

    @Test
    public void testFileUrl() throws Exception {
        EndpointURI url = this.newMuleEndpointURI("file:///C:/temp?endpointName=fileEndpoint");
        Assert.assertEquals((Object)"file", (Object)url.getScheme());
        Assert.assertEquals((Object)"/C:/temp", (Object)url.getAddress());
        Assert.assertNotNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"fileEndpoint", (Object)url.getEndpointName());
        Assert.assertEquals((long)-1L, (long)url.getPort());
        Assert.assertEquals((Object)"file:///C:/temp?endpointName=fileEndpoint", (Object)url.toString());
        Assert.assertEquals((Object)"endpointName=fileEndpoint", (Object)url.getQuery());
        Assert.assertEquals((long)1L, (long)url.getParams().size());
    }

    @Test
    public void testFileUrlWithoutDrive() throws Exception {
        EndpointURI url = this.newMuleEndpointURI("file://temp?endpointName=fileEndpoint");
        Assert.assertEquals((Object)"file", (Object)url.getScheme());
        Assert.assertEquals((Object)"temp", (Object)url.getAddress());
        Assert.assertNotNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"fileEndpoint", (Object)url.getEndpointName());
        Assert.assertEquals((long)-1L, (long)url.getPort());
        Assert.assertEquals((Object)"file://temp?endpointName=fileEndpoint", (Object)url.toString());
        Assert.assertEquals((Object)"endpointName=fileEndpoint", (Object)url.getQuery());
        Assert.assertEquals((long)1L, (long)url.getParams().size());
    }

    @Test
    public void testRelativeFileUriParentDir() throws Exception {
        String muleURI = "file://../test-data/in";
        EndpointURI url = this.newMuleEndpointURI(muleURI);
        Assert.assertEquals((Object)"../test-data/in", (Object)url.getAddress());
    }

    @Test
    public void testRelativeFileUriCurrentDir() throws Exception {
        String muleURI = "file://./test-data/in";
        EndpointURI url = this.newMuleEndpointURI(muleURI);
        Assert.assertEquals((Object)"./test-data/in", (Object)url.getAddress());
    }

    @Test
    public void testWinNetworkUri() throws Exception {
        String muleURI = "file:////192.168.0.1/test/";
        EndpointURI url = this.newMuleEndpointURI(muleURI);
        Assert.assertEquals((Object)"//192.168.0.1/test/", (Object)url.getAddress());
    }

    @Test
    public void testRelativeFileUriAsParameter() throws Exception {
        EndpointURI url = this.newMuleEndpointURI("file://?address=./temp&endpointName=fileEndpoint");
        Assert.assertEquals((Object)"file", (Object)url.getScheme());
        Assert.assertEquals((Object)"./temp", (Object)url.getAddress());
        Assert.assertNotNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"fileEndpoint", (Object)url.getEndpointName());
        Assert.assertEquals((long)-1L, (long)url.getPort());
        Assert.assertEquals((Object)"file://?address=./temp&endpointName=fileEndpoint", (Object)url.toString());
        Assert.assertEquals((Object)"address=./temp&endpointName=fileEndpoint", (Object)url.getQuery());
        Assert.assertEquals((long)2L, (long)url.getParams().size());
    }
}

