/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.reliability;

import java.io.File;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.construct.Flow;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.probe.Probe;
import org.mule.transport.file.reliability.InboundMessageLossTestCase;
import org.mule.util.concurrent.Latch;

public class InboundMessageLossFlowTestCase
extends InboundMessageLossTestCase {
    public InboundMessageLossFlowTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Override
    protected String getConfigResources() {
        return "reliability/inbound-message-loss-flow.xml";
    }

    @Override
    @Test
    public void testTransformerException() throws Exception {
        this.tmpDir = this.createFolder(".mule/transformerException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Override
    @Test
    public void testRouterException() throws Exception {
        this.tmpDir = this.createFolder(".mule/routerException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return !file.exists();
            }

            public String describeFailure() {
                return "File should be gone";
            }
        });
    }

    @Test
    public void testFlowRefException() throws Exception {
        if (this.variant.equals((Object)AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE)) {
            return;
        }
        final Latch exceptionThrownLatch = new Latch();
        this.tmpDir = this.createFolder(".mule/flowRefException");
        final File file = this.createDataFile(this.tmpDir, "test1.txt");
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("failingFlow");
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                exceptionThrownLatch.release();
                throw new RuntimeException();
            }
        });
        Flow flow = (Flow)this.getFlowConstruct("FlowRefException");
        flow.stop();
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return file.exists();
            }

            public String describeFailure() {
                return "File should have been restored";
            }
        });
    }
}

