/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.file.ExpressionFilenameParser;

public class ExpressionFilenameParserTestCase
extends AbstractMuleContextTestCase {
    private ExpressionFilenameParser parser;
    private MuleMessage message;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.parser = new ExpressionFilenameParser();
        this.parser.setMuleContext(muleContext);
        this.message = new DefaultMuleMessage((Object)"hello", muleContext);
        this.message.setOutboundProperty("foo", (Object)"bar");
        this.message.setProperty("originalFilename", (Object)"originalName", PropertyScope.INBOUND);
        this.message.setProperty("filename", (Object)"newName", PropertyScope.INBOUND);
    }

    @Test
    public void testWigglyMuleStyleParsing() {
        String result = this.parser.getFilename(this.message, "Test1_#[function:count].txt");
        Assert.assertEquals((Object)"Test1_0.txt", (Object)result);
        result = this.parser.getFilename(this.message, "Test2_#[function:datestamp-yyMMdd].txt");
        this.assertDatestampWithYearMonthAndDayMatches(result);
        result = this.parser.getFilename(this.message, "Test3_#[function:datestamp].txt");
        this.assertDefaultDatestampMatches(result);
        result = this.parser.getFilename(this.message, "Test4_#[function:systime].txt");
        Assert.assertFalse((boolean)result.equals("Test4_#[function:systime].txt"));
        result = this.parser.getFilename(this.message, "Test5_#[function:uuid].txt");
        Assert.assertFalse((boolean)result.equals("Test5_#[function:uuid].txt"));
        result = this.parser.getFilename(this.message, "Test6_#[function:count].txt");
        Assert.assertEquals((Object)"Test6_1.txt", (Object)result);
        result = this.parser.getFilename(this.message, "Test7_#[header:inbound:originalFilename].txt");
        Assert.assertEquals((Object)"Test7_originalName.txt", (Object)result);
        result = this.parser.getFilename(this.message, "Test8_#[header:foo].txt");
        Assert.assertEquals((Object)"Test8_bar.txt", (Object)result);
        result = this.parser.getFilename(this.message, "Test9_#[header:xxx?].txt");
        Assert.assertEquals((Object)"Test9_null.txt", (Object)result);
        try {
            result = this.parser.getFilename(this.message, "Test9_#[header:xxx].txt");
            Assert.fail((String)"Property xxx is not available");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSquareStyleParsing() {
        String result = this.parser.getFilename(this.message, "Test1_[function:count].txt");
        Assert.assertEquals((Object)"Test1_0.txt", (Object)result);
        result = this.parser.getFilename(this.message, "Test2_[function:dateStamp-yyMMdd].txt");
        this.assertDatestampWithYearMonthAndDayMatches(result);
        result = this.parser.getFilename(this.message, "Test3_[function:dateStamp].txt");
        this.assertDefaultDatestampMatches(result);
        result = this.parser.getFilename(this.message, "Test4_[function:systime].txt");
        Assert.assertFalse((boolean)result.equals("Test4_[function:systime].txt"));
        result = this.parser.getFilename(this.message, "Test5_[function:uuid].txt");
        Assert.assertFalse((boolean)result.equals("Test5_[function:uuid].txt"));
        result = this.parser.getFilename(this.message, "Test6_[function:count].txt");
        Assert.assertEquals((Object)"Test6_1.txt", (Object)result);
        result = this.parser.getFilename(this.message, "Test7_[header:inbound:originalFilename].txt");
        Assert.assertEquals((Object)"Test7_originalName.txt", (Object)result);
        result = this.parser.getFilename(this.message, "Test8_[header:foo].txt");
        Assert.assertEquals((Object)"Test8_bar.txt", (Object)result);
        try {
            result = this.parser.getFilename(this.message, "Test9_[header:xxx].txt");
            Assert.fail((String)"Property xxx is not available");
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = this.parser.getFilename(this.message, "Test9_[header:xxx?].txt");
        Assert.assertEquals((Object)"Test9_null.txt", (Object)result);
    }

    private void assertDatestampWithYearMonthAndDayMatches(String result) {
        Date now = new Date();
        String expected = String.format("Test2_%1$ty%1$tm%1$td.txt", now);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private void assertDefaultDatestampMatches(String result) {
        Date now = new Date();
        String expected = String.format("Test3_%1$td-%1$tm-%1$ty_%1$tH-%1$tM-.*.txt", now);
        Assert.assertTrue((boolean)result.matches(expected));
    }
}

