/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.file.FileMessageReceiver;
import org.mule.transport.file.FileTestUtils;
import org.mule.util.FileUtils;

public class FileAgeAndPollingFrequencyInteractionTestCase
extends FunctionalTestCase {
    private static File dataFile;
    private static boolean updateFileAge;

    public FileAgeAndPollingFrequencyInteractionTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "file-age-polling-config.xml";
    }

    @Test
    public void processesFileOnNextPollWhenFileIsOldEnough() throws Exception {
        File tmpDir = FileUtils.openDirectory((String)".mule/in");
        dataFile = FileTestUtils.createDataFile(tmpDir, "Test Message", "UTF-8");
        muleContext.start();
        MuleMessage response = muleContext.getClient().request("vm://testOut", 5000L);
        Assert.assertNotNull((String)"File was not processed", (Object)response);
        Assert.assertEquals((Object)"Test Message", (Object)response.getPayloadAsString());
    }

    static {
        updateFileAge = true;
    }

    public static class TestFileMessageReceiver
    extends FileMessageReceiver {
        public TestFileMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, String readDir, String moveDir, String moveToPattern, long frequency) throws CreateException {
            super(connector, flowConstruct, endpoint, readDir, moveDir, moveToPattern, frequency);
        }

        public void poll() {
            super.poll();
            if (updateFileAge) {
                dataFile.setLastModified(System.currentTimeMillis() - 500000L);
                updateFileAge = false;
            }
        }
    }
}

